/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.dotnet.shared.plugins;

import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.util.Map;
import org.sonar.api.SonarQubeVersion;
import org.sonar.api.batch.BatchSide;
import org.sonar.api.batch.ScannerSide;
import org.sonar.api.batch.bootstrap.ProjectDefinition;
import org.sonar.api.batch.fs.InputFile;
import org.sonar.api.utils.Version;
import org.sonar.api.utils.log.Logger;
import org.sonar.api.utils.log.Loggers;
import org.sonarsource.dotnet.shared.plugins.protobuf.EncodingImporter;
import org.sonarsource.dotnet.shared.plugins.protobuf.ProtobufImporters;

@BatchSide
@ScannerSide
public class EncodingPerFile {
    private static final Logger LOG = Loggers.get(EncodingPerFile.class);
    private static final Version INPUT_FILE_CHARSET = Version.create((int)6, (int)1);
    private Map<Path, Charset> roslynEncodingPerPath;
    private final ProjectDefinition projectDef;
    private final SonarQubeVersion sonarQubeVersion;

    public EncodingPerFile(ProjectDefinition projectDef, SonarQubeVersion sonarQubeVersion) {
        this.projectDef = projectDef;
        this.sonarQubeVersion = sonarQubeVersion;
    }

    void init(Path reportDir) {
        EncodingImporter encodingImporter = this.getEncodingImporter();
        Path encodingReportProtobuf = reportDir.resolve("encoding.pb");
        if (encodingReportProtobuf.toFile().exists()) {
            encodingImporter.accept(encodingReportProtobuf);
        } else {
            LOG.warn("Protobuf file not found: {}", (Object)encodingReportProtobuf);
        }
        this.roslynEncodingPerPath = encodingImporter.getEncodingPerPath();
    }

    EncodingImporter getEncodingImporter() {
        return ProtobufImporters.encodingImporter();
    }

    boolean encodingMatch(InputFile inputFile) {
        String encoding;
        Path inputFilePath = inputFile.path().toAbsolutePath();
        if (!this.roslynEncodingPerPath.containsKey(inputFilePath)) {
            return true;
        }
        Charset roslynEncoding = this.roslynEncodingPerPath.get(inputFilePath);
        if (roslynEncoding == null) {
            LOG.warn("File '{}' does not have encoding information. Skip it.", (Object)inputFilePath);
            return false;
        }
        Charset sqEncoding = this.sonarQubeVersion.isGreaterThanOrEqual(INPUT_FILE_CHARSET) ? inputFile.charset() : ((encoding = (String)this.projectDef.properties().get("sonar.sourceEncoding")) != null && encoding.length() > 0 ? Charset.forName(encoding) : Charset.defaultCharset());
        boolean sameEncoding = sqEncoding.equals(roslynEncoding);
        if (!sameEncoding) {
            if (sqEncoding.equals(StandardCharsets.UTF_16LE) && roslynEncoding.equals(StandardCharsets.UTF_16)) {
                sameEncoding = true;
            } else {
                LOG.warn("Encoding detected by Roslyn and encoding used by SonarQube do not match for file {}. SonarQube encoding is '{}', Roslyn encoding is '{}'. File will be skipped.", new Object[]{inputFilePath, sqEncoding, roslynEncoding});
            }
        }
        return sameEncoding;
    }
}

