/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.dotnet.shared.plugins.protobuf;

import java.nio.charset.Charset;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import org.sonar.api.utils.log.Logger;
import org.sonar.api.utils.log.Loggers;
import org.sonarsource.dotnet.protobuf.SonarAnalyzer;
import org.sonarsource.dotnet.shared.plugins.protobuf.RawProtobufImporter;

public class EncodingImporter
extends RawProtobufImporter<SonarAnalyzer.EncodingInfo> {
    private static final Logger LOG = Loggers.get(EncodingImporter.class);
    private final Map<String, Charset> encodingPerPath = new HashMap<String, Charset>();

    EncodingImporter() {
        super(SonarAnalyzer.EncodingInfo.parser());
    }

    @Override
    void consume(SonarAnalyzer.EncodingInfo message) {
        String roslynEncoding = message.getEncoding();
        Charset charset = null;
        if (!roslynEncoding.isEmpty()) {
            try {
                charset = Charset.forName(roslynEncoding);
            }
            catch (Exception e) {
                LOG.warn("Unrecognized encoding {} for file {}", new Object[]{roslynEncoding, message.getFilePath(), e});
            }
        }
        this.encodingPerPath.put(message.getFilePath(), charset);
    }

    public Map<Path, Charset> getEncodingPerPath() {
        return this.encodingPerPath.entrySet().stream().collect(Collectors.toMap(entry -> Paths.get((String)entry.getKey(), new String[0]), Map.Entry::getValue));
    }
}

