/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.dotnet.shared.plugins.protobuf;

import java.util.function.Predicate;
import javax.annotation.CheckForNull;
import org.sonar.api.batch.fs.InputFile;
import org.sonar.api.batch.sensor.SensorContext;
import org.sonar.api.batch.sensor.highlighting.NewHighlighting;
import org.sonar.api.batch.sensor.highlighting.TypeOfText;
import org.sonarsource.dotnet.protobuf.SonarAnalyzer;
import org.sonarsource.dotnet.shared.plugins.SensorContextUtils;
import org.sonarsource.dotnet.shared.plugins.protobuf.ProtobufImporter;

class HighlightImporter
extends ProtobufImporter<SonarAnalyzer.TokenTypeInfo> {
    private final SensorContext context;

    HighlightImporter(SensorContext context, Predicate<InputFile> inputFileFilter) {
        super(SonarAnalyzer.TokenTypeInfo.parser(), context, inputFileFilter, SonarAnalyzer.TokenTypeInfo::getFilePath);
        this.context = context;
    }

    @Override
    void consumeFor(InputFile inputFile, SonarAnalyzer.TokenTypeInfo message) {
        NewHighlighting highlights = this.context.newHighlighting().onFile(inputFile);
        boolean foundMappableHighlights = false;
        for (SonarAnalyzer.TokenTypeInfo.TokenInfo tokenInfo : message.getTokenInfoList()) {
            TypeOfText typeOfText = HighlightImporter.toType(tokenInfo.getTokenType());
            if (typeOfText == null) continue;
            highlights.highlight(SensorContextUtils.toTextRange(inputFile, tokenInfo.getTextRange()), typeOfText);
            foundMappableHighlights = true;
        }
        if (foundMappableHighlights) {
            highlights.save();
        }
    }

    @CheckForNull
    private static TypeOfText toType(SonarAnalyzer.TokenType tokenType) {
        switch (tokenType) {
            case NUMERIC_LITERAL: {
                return TypeOfText.CONSTANT;
            }
            case COMMENT: {
                return TypeOfText.COMMENT;
            }
            case KEYWORD: {
                return TypeOfText.KEYWORD;
            }
            case TYPE_NAME: {
                return TypeOfText.KEYWORD_LIGHT;
            }
            case STRING_LITERAL: {
                return TypeOfText.STRING;
            }
        }
        return null;
    }
}

