/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.dotnet.shared.plugins.protobuf;

import java.util.function.Predicate;
import org.sonar.api.batch.fs.InputComponent;
import org.sonar.api.batch.fs.InputFile;
import org.sonar.api.batch.sensor.SensorContext;
import org.sonar.api.batch.sensor.issue.NewIssue;
import org.sonar.api.batch.sensor.issue.NewIssueLocation;
import org.sonar.api.rule.RuleKey;
import org.sonarsource.dotnet.protobuf.SonarAnalyzer;
import org.sonarsource.dotnet.shared.plugins.SensorContextUtils;
import org.sonarsource.dotnet.shared.plugins.protobuf.ProtobufImporter;

class IssuesImporter
extends ProtobufImporter<SonarAnalyzer.FileIssues> {
    private final SensorContext context;
    private final String repositoryKey;

    IssuesImporter(SensorContext context, String repositoryKey, Predicate<InputFile> inputFileFilter) {
        super(SonarAnalyzer.FileIssues.parser(), context, inputFileFilter, SonarAnalyzer.FileIssues::getFilePath);
        this.context = context;
        this.repositoryKey = repositoryKey;
    }

    @Override
    void consumeFor(InputFile inputFile, SonarAnalyzer.FileIssues message) {
        for (SonarAnalyzer.FileIssues.Issue issue : message.getIssueList()) {
            NewIssue newIssue = this.context.newIssue();
            NewIssueLocation location = newIssue.newLocation().on((InputComponent)inputFile).message(issue.getMessage());
            SonarAnalyzer.TextRange issueTextRange = issue.getLocation();
            if (issueTextRange.getStartOffset() != issueTextRange.getEndOffset() || issueTextRange.getStartLine() != issueTextRange.getEndLine()) {
                location = location.at(SensorContextUtils.toTextRange(inputFile, issueTextRange));
            }
            newIssue.forRule(RuleKey.of((String)this.repositoryKey, (String)issue.getId())).at(location).save();
        }
    }
}

