/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.dotnet.shared.plugins.protobuf;

import java.io.Serializable;
import java.util.HashSet;
import java.util.function.Predicate;
import org.sonar.api.batch.fs.InputComponent;
import org.sonar.api.batch.fs.InputFile;
import org.sonar.api.batch.measure.Metric;
import org.sonar.api.batch.sensor.SensorContext;
import org.sonar.api.issue.NoSonarFilter;
import org.sonar.api.measures.CoreMetrics;
import org.sonar.api.measures.FileLinesContext;
import org.sonar.api.measures.FileLinesContextFactory;
import org.sonar.api.utils.Version;
import org.sonarsource.dotnet.protobuf.SonarAnalyzer;
import org.sonarsource.dotnet.shared.plugins.protobuf.ProtobufImporter;

class MetricsImporter
extends ProtobufImporter<SonarAnalyzer.MetricsInfo> {
    private final SensorContext context;
    private final FileLinesContextFactory fileLinesContextFactory;
    private final NoSonarFilter noSonarFilter;
    private final boolean supportsCognitiveComplexity;

    MetricsImporter(SensorContext context, FileLinesContextFactory fileLinesContextFactory, NoSonarFilter noSonarFilter, Predicate<InputFile> inputFileFilter) {
        super(SonarAnalyzer.MetricsInfo.parser(), context, inputFileFilter, SonarAnalyzer.MetricsInfo::getFilePath);
        this.context = context;
        this.fileLinesContextFactory = fileLinesContextFactory;
        this.noSonarFilter = noSonarFilter;
        this.supportsCognitiveComplexity = this.isSonarQubeGreaterThanOrEqualTo63();
    }

    @Override
    void consumeFor(InputFile inputFile, SonarAnalyzer.MetricsInfo message) {
        boolean cognitiveComplexityError;
        MetricsImporter.saveMetric(this.context, inputFile, CoreMetrics.CLASSES, message.getClassCount());
        MetricsImporter.saveMetric(this.context, inputFile, CoreMetrics.STATEMENTS, message.getStatementCount());
        MetricsImporter.saveMetric(this.context, inputFile, CoreMetrics.FUNCTIONS, message.getFunctionCount());
        MetricsImporter.saveMetric(this.context, inputFile, CoreMetrics.PUBLIC_API, message.getPublicApiCount());
        MetricsImporter.saveMetric(this.context, inputFile, CoreMetrics.PUBLIC_UNDOCUMENTED_API, message.getPublicUndocumentedApiCount());
        MetricsImporter.saveMetric(this.context, inputFile, CoreMetrics.COMPLEXITY, message.getComplexity());
        MetricsImporter.saveMetric(this.context, inputFile, CoreMetrics.FILE_COMPLEXITY_DISTRIBUTION, message.getFileComplexityDistribution());
        MetricsImporter.saveMetric(this.context, inputFile, CoreMetrics.FUNCTION_COMPLEXITY_DISTRIBUTION, message.getFunctionComplexityDistribution());
        MetricsImporter.saveMetric(this.context, inputFile, CoreMetrics.COMPLEXITY_IN_CLASSES, message.getComplexityInClasses());
        MetricsImporter.saveMetric(this.context, inputFile, CoreMetrics.COMPLEXITY_IN_FUNCTIONS, message.getComplexityInFunctions());
        this.noSonarFilter.noSonarInFile(inputFile, new HashSet<Integer>(message.getNoSonarCommentList()));
        FileLinesContext fileLinesContext = this.fileLinesContextFactory.createFor(inputFile);
        for (int line : message.getNonBlankCommentList()) {
            fileLinesContext.setIntValue("comment_lines_data", line, 1);
        }
        MetricsImporter.saveMetric(this.context, inputFile, CoreMetrics.COMMENT_LINES, message.getNonBlankCommentCount());
        for (int line : message.getCodeLineList()) {
            fileLinesContext.setIntValue("ncloc_data", line, 1);
        }
        MetricsImporter.saveMetric(this.context, inputFile, CoreMetrics.NCLOC, message.getCodeLineCount());
        boolean bl = cognitiveComplexityError = message.getCognitiveComplexity() < 0;
        if (this.supportsCognitiveComplexity && !cognitiveComplexityError) {
            MetricsImporter.saveMetric(this.context, inputFile, CoreMetrics.COGNITIVE_COMPLEXITY, message.getCognitiveComplexity());
        }
        fileLinesContext.save();
    }

    private boolean isSonarQubeGreaterThanOrEqualTo63() {
        return this.context.getSonarQubeVersion().isGreaterThanOrEqual(Version.create((int)6, (int)3));
    }

    private static <T extends Serializable> void saveMetric(SensorContext context, InputFile inputFile, Metric<T> metric, T value) {
        context.newMeasure().on((InputComponent)inputFile).forMetric(metric).withValue(value).save();
    }
}

