/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.dotnet.shared.plugins.protobuf;

import com.google.protobuf.Parser;
import java.util.function.Function;
import java.util.function.Predicate;
import org.sonar.api.batch.fs.InputFile;
import org.sonar.api.batch.sensor.SensorContext;
import org.sonarsource.dotnet.shared.plugins.SensorContextUtils;
import org.sonarsource.dotnet.shared.plugins.protobuf.RawProtobufImporter;

public abstract class ProtobufImporter<T>
extends RawProtobufImporter<T> {
    private final Function<T, String> toFilePath;
    private final SensorContext context;
    private final Predicate<InputFile> filter;

    ProtobufImporter(Parser<T> parser, SensorContext context, Predicate<InputFile> filter, Function<T, String> toFilePath) {
        super(parser);
        this.context = context;
        this.filter = filter;
        this.toFilePath = toFilePath;
    }

    @Override
    final void consume(T message) {
        InputFile inputFile = SensorContextUtils.toInputFile(this.context.fileSystem(), this.toFilePath.apply(message));
        if (inputFile == null || !this.filter.test(inputFile)) {
            return;
        }
        this.consumeFor(inputFile, message);
    }

    abstract void consumeFor(InputFile var1, T var2);
}

