/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.dotnet.shared.plugins.protobuf;

import java.util.function.Predicate;
import org.sonar.api.batch.fs.InputFile;
import org.sonar.api.batch.sensor.SensorContext;
import org.sonar.api.issue.NoSonarFilter;
import org.sonar.api.measures.FileLinesContextFactory;
import org.sonarsource.dotnet.shared.plugins.protobuf.CPDTokensImporter;
import org.sonarsource.dotnet.shared.plugins.protobuf.EncodingImporter;
import org.sonarsource.dotnet.shared.plugins.protobuf.HighlightImporter;
import org.sonarsource.dotnet.shared.plugins.protobuf.IssuesImporter;
import org.sonarsource.dotnet.shared.plugins.protobuf.MetricsImporter;
import org.sonarsource.dotnet.shared.plugins.protobuf.RawProtobufImporter;
import org.sonarsource.dotnet.shared.plugins.protobuf.SymbolRefsImporter;

public final class ProtobufImporters {
    public static final String HIGHLIGHT_OUTPUT_PROTOBUF_NAME = "token-type.pb";
    public static final String SYMBOLREFS_OUTPUT_PROTOBUF_NAME = "symrefs.pb";
    public static final String CPDTOKENS_OUTPUT_PROTOBUF_NAME = "token-cpd.pb";
    public static final String METRICS_OUTPUT_PROTOBUF_NAME = "metrics.pb";
    public static final String ISSUES_OUTPUT_PROTOBUF_NAME = "issues.pb";
    public static final String ENCODING_OUTPUT_PROTOBUF_NAME = "encoding.pb";

    private ProtobufImporters() {
    }

    public static RawProtobufImporter highlightImporter(SensorContext context, Predicate<InputFile> inputFileFilter) {
        return new HighlightImporter(context, inputFileFilter);
    }

    public static RawProtobufImporter symbolRefsImporter(SensorContext context, Predicate<InputFile> inputFileFilter) {
        return new SymbolRefsImporter(context, inputFileFilter);
    }

    public static RawProtobufImporter cpdTokensImporter(SensorContext context, Predicate<InputFile> inputFileFilter) {
        return new CPDTokensImporter(context, inputFileFilter);
    }

    public static RawProtobufImporter metricsImporter(SensorContext context, FileLinesContextFactory fileLinesContextFactory, NoSonarFilter noSonarFilter, Predicate<InputFile> inputFileFilter) {
        return new MetricsImporter(context, fileLinesContextFactory, noSonarFilter, inputFileFilter);
    }

    public static RawProtobufImporter issuesImporter(SensorContext context, String repositoryKey, Predicate<InputFile> inputFileFilter) {
        return new IssuesImporter(context, repositoryKey, inputFileFilter);
    }

    public static EncodingImporter encodingImporter() {
        return new EncodingImporter();
    }
}

