/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.dotnet.shared.plugins.protobuf;

import java.util.function.Predicate;
import org.sonar.api.batch.fs.InputFile;
import org.sonar.api.batch.sensor.SensorContext;
import org.sonar.api.batch.sensor.symbol.NewSymbol;
import org.sonar.api.batch.sensor.symbol.NewSymbolTable;
import org.sonarsource.dotnet.protobuf.SonarAnalyzer;
import org.sonarsource.dotnet.shared.plugins.SensorContextUtils;
import org.sonarsource.dotnet.shared.plugins.protobuf.ProtobufImporter;

class SymbolRefsImporter
extends ProtobufImporter<SonarAnalyzer.SymbolReferenceInfo> {
    private final SensorContext context;

    SymbolRefsImporter(SensorContext context, Predicate<InputFile> inputFileFilter) {
        super(SonarAnalyzer.SymbolReferenceInfo.parser(), context, inputFileFilter, SonarAnalyzer.SymbolReferenceInfo::getFilePath);
        this.context = context;
    }

    @Override
    void consumeFor(InputFile inputFile, SonarAnalyzer.SymbolReferenceInfo message) {
        NewSymbolTable symbolTable = this.context.newSymbolTable().onFile(inputFile);
        for (SonarAnalyzer.SymbolReferenceInfo.SymbolReference tokenInfo : message.getReferenceList()) {
            NewSymbol symbol = symbolTable.newSymbol(SensorContextUtils.toTextRange(inputFile, tokenInfo.getDeclaration()));
            for (SonarAnalyzer.TextRange refTextRange : tokenInfo.getReferenceList()) {
                symbol.newReference(SensorContextUtils.toTextRange(inputFile, refTextRange));
            }
        }
        symbolTable.save();
    }
}

