/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.dotnet.shared.sarif;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.reflect.TypeToken;
import java.io.File;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import org.sonarsource.dotnet.shared.sarif.Location;
import org.sonarsource.dotnet.shared.sarif.SarifParser;
import org.sonarsource.dotnet.shared.sarif.SarifParserCallback;

class SarifParser10
implements SarifParser {
    private JsonObject root;

    SarifParser10(JsonObject root) {
        this.root = root;
    }

    @Override
    public void accept(SarifParserCallback callback) {
        if (!this.root.has("runs")) {
            return;
        }
        for (JsonElement runElement : this.root.get("runs").getAsJsonArray()) {
            JsonObject run = runElement.getAsJsonObject();
            JsonArray results = run.getAsJsonArray("results");
            if (results == null) continue;
            SarifParser10.handleIssues(results, callback);
        }
    }

    private static void handleIssues(JsonArray results, SarifParserCallback callback) {
        for (JsonElement resultEl : results) {
            JsonObject resultObj = resultEl.getAsJsonObject();
            SarifParser10.handleIssue(resultObj, callback);
        }
    }

    private static void handleIssue(JsonObject resultObj, SarifParserCallback callback) {
        String message;
        if (SarifParser10.isSuppressed(resultObj)) {
            return;
        }
        String ruleId = resultObj.get("ruleId").getAsString();
        if (!SarifParser10.handleLocationsElement(resultObj, ruleId, message = resultObj.get("message").getAsString(), callback)) {
            callback.onProjectIssue(ruleId, message);
        }
    }

    private static boolean handleLocationsElement(JsonObject resultObj, String ruleId, String message, SarifParserCallback callback) {
        JsonObject properties;
        if (!resultObj.has("locations")) {
            return false;
        }
        JsonArray locations = resultObj.getAsJsonArray("locations");
        if (locations.size() != 1) {
            return false;
        }
        JsonArray relatedLocations = new JsonArray();
        if (resultObj.has("relatedLocations")) {
            relatedLocations = resultObj.getAsJsonArray("relatedLocations");
        }
        Map<String, String> messageMap = new HashMap<String, String>();
        if (resultObj.has("properties") && (properties = resultObj.getAsJsonObject("properties")).has("customProperties")) {
            messageMap = (Map)new Gson().fromJson(properties.get("customProperties"), new TypeToken<Map<String, String>>(){}.getType());
        }
        JsonObject firstIssueLocation = locations.get(0).getAsJsonObject().getAsJsonObject("resultFile");
        return SarifParser10.handleResultFileElement(ruleId, message, firstIssueLocation, relatedLocations, messageMap, callback);
    }

    private static boolean handleResultFileElement(String ruleId, String message, JsonObject resultFileObj, JsonArray relatedLocations, Map<String, String> messageMap, SarifParserCallback callback) {
        if (!resultFileObj.has("uri") || !resultFileObj.has("region")) {
            return false;
        }
        Location primaryLocation = SarifParser10.handleLocation(resultFileObj, message);
        if (primaryLocation == null) {
            String uri = resultFileObj.get("uri").getAsString();
            String absolutePath = SarifParser10.uriToAbsolutePath(uri);
            callback.onFileIssue(ruleId, absolutePath, message);
        } else {
            ArrayList<Location> secondaryLocations = new ArrayList<Location>();
            for (JsonElement relatedLocationEl : relatedLocations) {
                JsonObject relatedLocationObj = relatedLocationEl.getAsJsonObject().getAsJsonObject("physicalLocation");
                if (!relatedLocationObj.has("uri")) {
                    return false;
                }
                String secondaryMessage = messageMap.getOrDefault(String.valueOf(secondaryLocations.size()), null);
                Location secondaryLocation = SarifParser10.handleLocation(relatedLocationObj, secondaryMessage);
                if (secondaryLocation == null) {
                    return false;
                }
                secondaryLocations.add(secondaryLocation);
            }
            callback.onIssue(ruleId, primaryLocation, secondaryLocations);
        }
        return true;
    }

    @CheckForNull
    private static Location handleLocation(JsonObject locationObj, @Nullable String message) {
        String uri = locationObj.get("uri").getAsString();
        String absolutePath = SarifParser10.uriToAbsolutePath(uri);
        JsonObject region = locationObj.get("region").getAsJsonObject();
        int startLine = region.get("startLine").getAsInt();
        JsonElement startColumnOrNull = region.get("startColumn");
        int startColumn = startColumnOrNull != null ? startColumnOrNull.getAsInt() : 1;
        int startLineOffset = startColumn - 1;
        JsonElement lengthOrNull = region.get("length");
        if (lengthOrNull != null) {
            return new Location(absolutePath, message, startLine, startLineOffset, startLine, startLineOffset + lengthOrNull.getAsInt());
        }
        JsonElement endLineOrNull = region.get("endLine");
        int endLine = endLineOrNull != null ? endLineOrNull.getAsInt() : startLine;
        JsonElement endColumnOrNull = region.get("endColumn");
        int endColumn = endColumnOrNull != null ? endColumnOrNull.getAsInt() : (endLineOrNull != null ? (endLine == startLine ? startColumn : 1) : startColumn);
        int endLineOffset = endColumn - 1;
        if (startColumn == endColumn && startLine == endLine) {
            return null;
        }
        return new Location(absolutePath, message, startLine, startLineOffset, endLine, endLineOffset);
    }

    private static boolean isSuppressed(JsonObject resultObj) {
        JsonArray suppressionStates = resultObj.getAsJsonArray("suppressionStates");
        if (suppressionStates != null) {
            for (JsonElement entry : suppressionStates) {
                if (!"suppressedInSource".equals(entry.getAsString())) continue;
                return true;
            }
        }
        return false;
    }

    private static String uriToAbsolutePath(String uri) {
        return new File(URI.create(uri)).getAbsolutePath();
    }
}

