/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.dotnet.tests;

import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Predicate;
import org.sonar.api.utils.log.Logger;
import org.sonar.api.utils.log.Loggers;
import org.sonar.plugins.dotnet.tests.Coverage;
import org.sonar.plugins.dotnet.tests.CoverageParser;
import org.sonar.plugins.dotnet.tests.XmlParserHelper;

public class NCover3ReportParser
implements CoverageParser {
    private static final Logger LOG = Loggers.get(NCover3ReportParser.class);
    private final Predicate<String> isSupportedLanguage;

    public NCover3ReportParser(Predicate<String> isSupportedLanguage) {
        this.isSupportedLanguage = isSupportedLanguage;
    }

    @Override
    public void accept(File file, Coverage coverage) {
        LOG.info("Parsing the NCover3 report " + file.getAbsolutePath());
        new Parser(file, coverage).parse();
    }

    private class Parser {
        private final File file;
        private final Map<String, String> documents = new HashMap<String, String>();
        private final Coverage coverage;

        Parser(File file, Coverage coverage) {
            this.file = file;
            this.coverage = coverage;
        }

        public void parse() {
            try (XmlParserHelper xmlParserHelper = new XmlParserHelper(this.file);){
                this.checkRootTag(xmlParserHelper);
                this.dispatchTags(xmlParserHelper);
            }
            catch (IOException e) {
                throw new IllegalStateException("Unable to close report", e);
            }
        }

        private void dispatchTags(XmlParserHelper xmlParserHelper) {
            String tagName;
            while ((tagName = xmlParserHelper.nextStartTag()) != null) {
                if ("doc".equals(tagName)) {
                    this.handleDocTag(xmlParserHelper);
                    continue;
                }
                if (!"seqpnt".equals(tagName)) continue;
                this.handleSegmentPointTag(xmlParserHelper);
            }
        }

        private void handleDocTag(XmlParserHelper xmlParserHelper) {
            String id = xmlParserHelper.getRequiredAttribute("id");
            String url = xmlParserHelper.getRequiredAttribute("url");
            if (!this.isExcludedId(id)) {
                try {
                    this.documents.put(id, new File(url).getCanonicalPath());
                }
                catch (IOException e) {
                    LOG.debug("Skipping the import of NCover3 code coverage for the invalid file path: " + url + " at line " + xmlParserHelper.stream().getLocation().getLineNumber(), (Object)e);
                }
            }
        }

        private boolean isExcludedId(String id) {
            return "0".equals(id);
        }

        private void handleSegmentPointTag(XmlParserHelper xmlParserHelper) {
            String doc = xmlParserHelper.getRequiredAttribute("doc");
            int line = xmlParserHelper.getRequiredIntAttribute("l");
            int vc = xmlParserHelper.getRequiredIntAttribute("vc");
            if (this.documents.containsKey(doc) && !this.isExcludedLine(line)) {
                String path = this.documents.get(doc);
                if (NCover3ReportParser.this.isSupportedLanguage.test(path)) {
                    this.coverage.addHits(path, line, vc);
                }
            }
        }

        private boolean isExcludedLine(Integer line) {
            return 0 == line;
        }

        private void checkRootTag(XmlParserHelper xmlParserHelper) {
            xmlParserHelper.checkRootTag("coverage");
            xmlParserHelper.checkRequiredAttribute("exportversion", 3);
        }
    }
}

