/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.dotnet.shared.plugins;

import javax.annotation.Nullable;
import org.sonar.api.SonarRuntime;
import org.sonar.api.server.profile.BuiltInQualityProfilesDefinition;
import org.sonar.api.utils.Version;
import org.sonarsource.analyzer.commons.BuiltInQualityProfileJsonLoader;

public abstract class AbstractSonarWayProfile
implements BuiltInQualityProfilesDefinition {
    private final boolean supportsSecurityHotspots;
    private static final Version SQ_7_3 = Version.create((int)7, (int)3);
    private final String languageKey;
    private final String pluginKey;
    private final String repositoryKey;

    protected AbstractSonarWayProfile(@Nullable SonarRuntime sonarRuntime, String languageKey, String pluginKey, String repositoryKey) {
        this.supportsSecurityHotspots = sonarRuntime != null && sonarRuntime.getApiVersion().isGreaterThanOrEqual(SQ_7_3);
        this.languageKey = languageKey;
        this.pluginKey = pluginKey;
        this.repositoryKey = repositoryKey;
    }

    public void define(BuiltInQualityProfilesDefinition.Context context) {
        BuiltInQualityProfilesDefinition.NewBuiltInQualityProfile sonarWay = context.createBuiltInQualityProfile("Sonar way", this.languageKey);
        String sonarWayJsonPath = this.getSonarWayJsonPath();
        BuiltInQualityProfileJsonLoader.load((BuiltInQualityProfilesDefinition.NewBuiltInQualityProfile)sonarWay, (String)this.repositoryKey, (String)sonarWayJsonPath);
        this.activateSecurityRules(sonarWay);
        sonarWay.done();
    }

    private String getSonarWayJsonPath() {
        return this.supportsSecurityHotspots ? "org/sonar/plugins/" + this.pluginKey + "/Sonar_way_profile.json" : "org/sonar/plugins/" + this.pluginKey + "/Sonar_way_profile_no_hotspot.json";
    }

    protected void activateSecurityRules(BuiltInQualityProfilesDefinition.NewBuiltInQualityProfile sonarWay) {
    }
}

