/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.dotnet.shared.plugins.protobuf;

import com.google.protobuf.Parser;
import java.nio.charset.Charset;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.sonar.api.utils.log.Logger;
import org.sonar.api.utils.log.Loggers;
import org.sonarsource.dotnet.protobuf.SonarAnalyzer;
import org.sonarsource.dotnet.shared.plugins.protobuf.RawProtobufImporter;

public class FileMetadataImporter
extends RawProtobufImporter<SonarAnalyzer.FileMetadataInfo> {
    private static final Logger LOG = Loggers.get(FileMetadataImporter.class);
    private final Map<String, Charset> encodingPerPath = new HashMap<String, Charset>();
    private final Set<Path> generatedFilePaths = new HashSet<Path>();

    FileMetadataImporter(Parser<SonarAnalyzer.FileMetadataInfo> parser) {
        super(parser);
    }

    public FileMetadataImporter() {
        this(SonarAnalyzer.FileMetadataInfo.parser());
    }

    @Override
    void consume(SonarAnalyzer.FileMetadataInfo message) {
        if (message.getIsGenerated()) {
            this.generatedFilePaths.add(Paths.get(message.getFilePath(), new String[0]));
        }
        String roslynEncoding = message.getEncoding();
        Charset charset = null;
        if (!roslynEncoding.isEmpty()) {
            try {
                charset = Charset.forName(roslynEncoding);
            }
            catch (Exception e) {
                LOG.warn(String.format("Unrecognized encoding %s for file %s", roslynEncoding, message.getFilePath()), (Throwable)e);
            }
        }
        this.encodingPerPath.put(message.getFilePath(), charset);
    }

    public Map<Path, Charset> getEncodingPerPath() {
        HashMap<Path, Charset> map = new HashMap<Path, Charset>();
        for (Map.Entry<String, Charset> e : this.encodingPerPath.entrySet()) {
            map.put(Paths.get(e.getKey(), new String[0]), e.getValue());
        }
        return Collections.unmodifiableMap(map);
    }

    public Set<Path> getGeneratedFilePaths() {
        return this.generatedFilePaths;
    }
}

