/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.dotnet.shared.sarif;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.function.UnaryOperator;
import org.sonarsource.dotnet.shared.plugins.RoslynReport;
import org.sonarsource.dotnet.shared.sarif.SarifParser;
import org.sonarsource.dotnet.shared.sarif.SarifParser01And04;
import org.sonarsource.dotnet.shared.sarif.SarifParser10;

public class SarifParserFactory {
    private SarifParserFactory() {
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static SarifParser create(RoslynReport report, UnaryOperator<String> toRealPath) {
        try (InputStreamReader reader = new InputStreamReader(Files.newInputStream(report.getReportPath(), new OpenOption[0]), StandardCharsets.UTF_8);){
            String version;
            JsonParser parser = new JsonParser();
            JsonObject root = parser.parse((Reader)reader).getAsJsonObject();
            if (!root.has("version")) throw new IllegalStateException(String.format("Unable to parse the Roslyn SARIF report file: %s. Unrecognized format", report.getReportPath().toAbsolutePath()));
            switch (version = root.get("version").getAsString()) {
                case "0.4": 
                case "0.1": {
                    SarifParser01And04 sarifParser01And04 = new SarifParser01And04(report.getModule(), root, toRealPath);
                    return sarifParser01And04;
                }
            }
            SarifParser10 sarifParser10 = new SarifParser10(report.getModule(), root, toRealPath);
            return sarifParser10;
        }
        catch (IOException e) {
            throw new IllegalStateException("Unable to read the Roslyn SARIF report file: " + report.getReportPath().toAbsolutePath(), e);
        }
    }
}

