/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.dotnet.shared.plugins;

import java.io.IOException;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.sonar.api.batch.ScannerSide;
import org.sonar.api.config.Configuration;
import org.sonar.api.utils.log.Logger;
import org.sonar.api.utils.log.Loggers;
import org.sonarsource.dotnet.shared.plugins.AbstractPropertyDefinitions;

@ScannerSide
public abstract class AbstractConfiguration {
    private static final Logger LOG = Loggers.get(AbstractConfiguration.class);
    private static final String MSG_SUFFIX = "Analyzer results won't be loaded from this directory.";
    private static final String PROP_PREFIX = "sonar.";
    private final Configuration configuration;
    private final String languageKey;

    public AbstractConfiguration(Configuration configuration, String languageKey) {
        this.configuration = configuration;
        this.languageKey = languageKey;
    }

    private String getOldRoslynJsonReportPathProperty() {
        return PROP_PREFIX + this.languageKey + ".roslyn.reportFilePath";
    }

    private String getOldAnalyzerWorkDirProperty() {
        return PROP_PREFIX + this.languageKey + ".analyzer.projectOutPath";
    }

    private String getAnalyzerReportDir() {
        return "output-" + this.languageKey;
    }

    public List<Path> protobufReportPaths() {
        return this.protobufReportPaths(false);
    }

    public List<Path> protobufReportPathsSilent() {
        return this.protobufReportPaths(true);
    }

    private List<Path> protobufReportPaths(boolean silent) {
        List<Object> analyzerWorkDirPaths = Arrays.stream(this.configuration.getStringArray(AbstractPropertyDefinitions.getAnalyzerWorkDirProperty(this.languageKey))).map(x$0 -> Paths.get(x$0, new String[0])).collect(Collectors.toList());
        if (analyzerWorkDirPaths.isEmpty()) {
            Optional oldValue = this.configuration.get(this.getOldAnalyzerWorkDirProperty());
            if (oldValue.isPresent()) {
                analyzerWorkDirPaths = Collections.singletonList(Paths.get((String)oldValue.get(), new String[0]));
            } else {
                return AbstractConfiguration.empty("Property missing: '" + AbstractPropertyDefinitions.getAnalyzerWorkDirProperty(this.languageKey) + "'. No protobuf files will be loaded for this project.", silent);
            }
        }
        return analyzerWorkDirPaths.stream().map(x -> x.resolve(this.getAnalyzerReportDir())).filter(p -> AbstractConfiguration.validateOutputDir(p, silent)).collect(Collectors.toList());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static boolean validateOutputDir(Path analyzerOutputDir, boolean silent) {
        String path = analyzerOutputDir.toString();
        try {
            if (!analyzerOutputDir.toFile().exists()) {
                AbstractConfiguration.ifNotSilent(silent, () -> LOG.warn("Analyzer working directory does not exist: '{}'. {}", (Object)path, (Object)MSG_SUFFIX));
                return false;
            }
            try (DirectoryStream<Path> files = Files.newDirectoryStream(analyzerOutputDir, AbstractConfiguration.protoFileFilter());){
                long count = StreamSupport.stream(files.spliterator(), false).count();
                if (count == 0L) {
                    AbstractConfiguration.ifNotSilent(silent, () -> LOG.warn("Analyzer working directory '{}' contains no .pb file(s). {}", (Object)path, (Object)MSG_SUFFIX));
                    boolean bl = false;
                    return bl;
                }
                AbstractConfiguration.ifNotSilent(silent, () -> LOG.debug("Analyzer working directory '{}' contains {} .pb file(s)", (Object)path, (Object)count));
                boolean bl = true;
                return bl;
            }
        }
        catch (IOException e) {
            throw new IllegalStateException("Could not check for .pb files in '" + path + "'", e);
        }
    }

    private static void ifNotSilent(boolean silent, Runnable r) {
        if (!silent) {
            r.run();
        }
    }

    private static DirectoryStream.Filter<Path> protoFileFilter() {
        return p -> p.getFileName().toString().toLowerCase().endsWith(".pb");
    }

    private static List<Path> empty(String msg, boolean silent) {
        AbstractConfiguration.ifNotSilent(silent, () -> LOG.warn(msg));
        return Collections.emptyList();
    }

    public List<Path> roslynReportPaths() {
        String[] strPaths = this.configuration.getStringArray(AbstractPropertyDefinitions.getRoslynJsonReportPathProperty(this.languageKey));
        if (strPaths.length > 0) {
            LOG.debug("Found Roslyn issues report");
            return Arrays.stream(strPaths).map(x$0 -> Paths.get(x$0, new String[0])).collect(Collectors.toList());
        }
        Optional<Path> path = this.configuration.get(this.getOldRoslynJsonReportPathProperty()).map(x$0 -> Paths.get(x$0, new String[0]));
        if (!path.isPresent()) {
            LOG.warn("No Roslyn issues report found for this project.");
            return Collections.emptyList();
        }
        LOG.debug("Found Roslyn issues report");
        return Collections.singletonList(path.get());
    }

    public boolean ignoreThirdPartyIssues() {
        return this.configuration.getBoolean(AbstractPropertyDefinitions.getIgnoreIssuesProperty(this.languageKey)).orElse(false);
    }

    public Set<String> bugCategories() {
        return new HashSet<String>(Arrays.asList(this.configuration.getStringArray(AbstractPropertyDefinitions.getBugCategoriesProperty(this.languageKey))));
    }

    public Set<String> codeSmellCategories() {
        return new HashSet<String>(Arrays.asList(this.configuration.getStringArray(AbstractPropertyDefinitions.getCodeSmellCategoriesProperty(this.languageKey))));
    }

    public Set<String> vulnerabilityCategories() {
        return new HashSet<String>(Arrays.asList(this.configuration.getStringArray(AbstractPropertyDefinitions.getVulnerabilityCategoriesProperty(this.languageKey))));
    }
}

