/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.dotnet.shared.plugins;

import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.util.Collections;
import java.util.Map;
import org.sonar.api.batch.ScannerSide;
import org.sonar.api.batch.fs.InputFile;
import org.sonar.api.utils.log.Logger;
import org.sonar.api.utils.log.Loggers;
import org.sonarsource.dotnet.shared.plugins.protobuf.EncodingImporter;
import org.sonarsource.dotnet.shared.plugins.protobuf.ProtobufImporters;

@ScannerSide
public class EncodingPerFile {
    private static final Logger LOG = Loggers.get(EncodingPerFile.class);
    private Map<Path, Charset> roslynEncodingPerPath;

    void init(Path protobufDir) {
        Path encodingReportProtobuf = protobufDir.resolve("encoding.pb");
        if (encodingReportProtobuf.toFile().exists()) {
            EncodingImporter encodingImporter = ProtobufImporters.encodingImporter();
            encodingImporter.accept(encodingReportProtobuf);
            this.roslynEncodingPerPath = encodingImporter.getEncodingPerPath();
            return;
        }
        this.roslynEncodingPerPath = Collections.emptyMap();
        LOG.warn("Protobuf file with encoding not found");
    }

    boolean encodingMatch(InputFile inputFile) {
        Path inputFilePath = inputFile.path().toAbsolutePath();
        if (!this.roslynEncodingPerPath.containsKey(inputFilePath)) {
            return true;
        }
        Charset roslynEncoding = this.roslynEncodingPerPath.get(inputFilePath);
        if (roslynEncoding == null) {
            LOG.warn("File '{}' does not have encoding information. Skip it.", (Object)inputFilePath);
            return false;
        }
        Charset sqEncoding = inputFile.charset();
        boolean sameEncoding = sqEncoding.equals(roslynEncoding);
        if (!sameEncoding) {
            if (sqEncoding.equals(StandardCharsets.UTF_16LE) && roslynEncoding.equals(StandardCharsets.UTF_16)) {
                sameEncoding = true;
            } else {
                LOG.warn("Encoding detected by Roslyn and encoding used by SonarQube do not match for file {}. SonarQube encoding is '{}', Roslyn encoding is '{}'. File will be skipped.", new Object[]{inputFilePath, sqEncoding, roslynEncoding});
            }
        }
        return sameEncoding;
    }
}

