/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.dotnet.shared.plugins;

import java.nio.file.Path;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.sonar.api.batch.fs.InputFile;
import org.sonar.api.batch.fs.InputFileFilter;
import org.sonar.api.utils.log.Logger;
import org.sonar.api.utils.log.Loggers;
import org.sonarsource.dotnet.shared.plugins.AbstractConfiguration;
import org.sonarsource.dotnet.shared.plugins.protobuf.FileMetadataImporter;
import org.sonarsource.dotnet.shared.plugins.protobuf.ProtobufImporters;

public class GeneratedFileFilter
implements InputFileFilter {
    private static final Logger LOG = Loggers.get(GeneratedFileFilter.class);
    private final AbstractConfiguration config;
    private final ProtobufImporters protobufImporters;
    private final Set<Path> generatedFilePaths = new HashSet<Path>();
    private boolean initialized;

    public GeneratedFileFilter(AbstractConfiguration config) {
        this(config, new ProtobufImporters());
    }

    GeneratedFileFilter(AbstractConfiguration config, ProtobufImporters protobufImporters) {
        this.config = config;
        this.protobufImporters = protobufImporters;
    }

    public boolean accept(InputFile inputFile) {
        this.initOnce();
        boolean isGenerated = this.generatedFilePaths.contains(inputFile.path());
        if (isGenerated) {
            LOG.debug("Skipping auto generated file: {}", (Object)inputFile);
        }
        return !isGenerated;
    }

    private synchronized void initOnce() {
        Path metadataPath;
        if (this.initialized) {
            return;
        }
        this.initialized = true;
        List<Path> protobufPath = this.config.protobufReportPathsSilent();
        if (!protobufPath.isEmpty() && (metadataPath = protobufPath.get(0).resolve("file-metadata.pb")).toFile().exists()) {
            FileMetadataImporter fileMetadataImporter = this.protobufImporters.fileMetadataImporter();
            fileMetadataImporter.accept(metadataPath);
            this.generatedFilePaths.addAll(fileMetadataImporter.getGeneratedFilePaths());
        }
    }
}

