/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.dotnet.shared.plugins;

import java.nio.file.Paths;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import org.sonar.api.batch.fs.InputComponent;
import org.sonar.api.batch.fs.InputFile;
import org.sonar.api.batch.fs.InputModule;
import org.sonar.api.batch.rule.Severity;
import org.sonar.api.batch.sensor.SensorContext;
import org.sonar.api.batch.sensor.issue.NewExternalIssue;
import org.sonar.api.batch.sensor.issue.NewIssue;
import org.sonar.api.batch.sensor.issue.NewIssueLocation;
import org.sonar.api.rule.RuleKey;
import org.sonar.api.rules.RuleType;
import org.sonar.api.utils.log.Logger;
import org.sonar.api.utils.log.Loggers;
import org.sonarsource.dotnet.shared.sarif.Location;
import org.sonarsource.dotnet.shared.sarif.SarifParserCallback;

public class SarifParserCallbackImpl
implements SarifParserCallback {
    private static final Logger LOG = Loggers.get(SarifParserCallbackImpl.class);
    private static final String EXTERNAL_ENGINE_ID = "roslyn";
    private final SensorContext context;
    private final Map<String, String> repositoryKeyByRoslynRuleKey;
    private final Set<Issue> savedIssues = new HashSet<Issue>();
    private final boolean ignoreThirdPartyIssues;
    private final Set<String> bugCategories;
    private final Set<String> codeSmellCategories;
    private final Set<String> vulnerabilityCategories;
    private final Map<String, String> defaultLevelByRuleId = new HashMap<String, String>();
    private final Map<String, RuleType> ruleTypeByRuleId = new HashMap<String, RuleType>();

    public SarifParserCallbackImpl(SensorContext context, Map<String, String> repositoryKeyByRoslynRuleKey, boolean ignoreThirdPartyIssues, Set<String> bugCategories, Set<String> codeSmellCategories, Set<String> vulnerabilityCategories) {
        this.context = context;
        this.repositoryKeyByRoslynRuleKey = repositoryKeyByRoslynRuleKey;
        this.ignoreThirdPartyIssues = ignoreThirdPartyIssues;
        this.bugCategories = bugCategories;
        this.codeSmellCategories = codeSmellCategories;
        this.vulnerabilityCategories = vulnerabilityCategories;
    }

    @Override
    public void onProjectIssue(String ruleId, @Nullable String level, InputModule inputModule, String message) {
        Issue issue = new Issue(ruleId, inputModule.toString(), true);
        if (!this.savedIssues.add(issue)) {
            return;
        }
        String repositoryKey = this.repositoryKeyByRoslynRuleKey.get(ruleId);
        if (repositoryKey != null) {
            this.createProjectLevelIssue(ruleId, inputModule, message, repositoryKey);
        }
    }

    private void createProjectLevelIssue(String ruleId, InputModule inputModule, String message, String repositoryKey) {
        NewIssue newIssue = this.context.newIssue();
        newIssue.forRule(RuleKey.of((String)repositoryKey, (String)ruleId)).at(newIssue.newLocation().on((InputComponent)inputModule).message(message)).save();
    }

    @Override
    public void onFileIssue(String ruleId, @Nullable String level, String absolutePath, String message) {
        Issue issue = new Issue(ruleId, absolutePath, false);
        if (!this.savedIssues.add(issue)) {
            return;
        }
        InputFile inputFile = this.context.fileSystem().inputFile(this.context.fileSystem().predicates().hasAbsolutePath(absolutePath));
        if (inputFile == null) {
            return;
        }
        String repositoryKey = this.repositoryKeyByRoslynRuleKey.get(ruleId);
        if (repositoryKey != null) {
            this.createFileLevelIssue(ruleId, message, repositoryKey, inputFile);
        } else if (!this.ignoreThirdPartyIssues) {
            this.createFileLevelExternalIssue(ruleId, level, message, inputFile);
        }
    }

    private void createFileLevelIssue(String ruleId, String message, String repositoryKey, InputFile inputFile) {
        NewIssue newIssue = this.context.newIssue();
        newIssue.forRule(RuleKey.of((String)repositoryKey, (String)ruleId)).at(newIssue.newLocation().on((InputComponent)inputFile).message(message)).save();
    }

    private void createFileLevelExternalIssue(String ruleId, @Nullable String level, String message, InputFile inputFile) {
        NewExternalIssue newIssue = this.newExternalIssue(ruleId);
        newIssue.at(newIssue.newLocation().on((InputComponent)inputFile).message(message));
        this.setExternalIssueSeverityAndType(ruleId, level, newIssue);
        newIssue.save();
    }

    @Override
    public void onIssue(String ruleId, @Nullable String level, Location primaryLocation, Collection<Location> secondaryLocations) {
        Issue issue = new Issue(ruleId, primaryLocation);
        if (!this.savedIssues.add(issue)) {
            return;
        }
        InputFile inputFile = this.context.fileSystem().inputFile(this.context.fileSystem().predicates().hasAbsolutePath(primaryLocation.getAbsolutePath()));
        if (inputFile == null) {
            return;
        }
        String repositoryKey = this.repositoryKeyByRoslynRuleKey.get(ruleId);
        if (repositoryKey != null) {
            this.createIssue(inputFile, ruleId, primaryLocation, secondaryLocations, repositoryKey);
        } else if (!this.ignoreThirdPartyIssues) {
            this.createExternalIssue(inputFile, ruleId, level, primaryLocation, secondaryLocations);
        }
    }

    private void createExternalIssue(InputFile inputFile, String ruleId, @Nullable String level, Location primaryLocation, Collection<Location> secondaryLocations) {
        NewExternalIssue newIssue = this.newExternalIssue(ruleId);
        newIssue.at(SarifParserCallbackImpl.createPrimaryLocation(inputFile, primaryLocation, () -> ((NewExternalIssue)newIssue).newLocation()));
        this.setExternalIssueSeverityAndType(ruleId, level, newIssue);
        this.populateSecondaryLocations(secondaryLocations, () -> ((NewExternalIssue)newIssue).newLocation(), arg_0 -> ((NewExternalIssue)newIssue).addLocation(arg_0));
        newIssue.save();
    }

    private void setExternalIssueSeverityAndType(String ruleId, @Nullable String level, NewExternalIssue newIssue) {
        if (level != null) {
            newIssue.severity(SarifParserCallbackImpl.mapSeverity(level));
        } else if (this.defaultLevelByRuleId.containsKey(ruleId)) {
            newIssue.severity(SarifParserCallbackImpl.mapSeverity(this.defaultLevelByRuleId.get(ruleId)));
        } else {
            LOG.warn("Rule {} was not found in the SARIF report, assuming default severity", (Object)ruleId);
            newIssue.severity(Severity.MAJOR);
        }
        newIssue.type(Optional.ofNullable(this.ruleTypeByRuleId.get(ruleId)).orElse(RuleType.CODE_SMELL));
    }

    private NewExternalIssue newExternalIssue(String ruleId) {
        NewExternalIssue newIssue = this.context.newExternalIssue();
        newIssue.engineId(EXTERNAL_ENGINE_ID).ruleId(ruleId);
        return newIssue;
    }

    private void createIssue(InputFile inputFile, String ruleId, Location primaryLocation, Collection<Location> secondaryLocations, String repositoryKey) {
        NewIssue newIssue = this.context.newIssue();
        newIssue.forRule(RuleKey.of((String)repositoryKey, (String)ruleId)).at(SarifParserCallbackImpl.createPrimaryLocation(inputFile, primaryLocation, () -> ((NewIssue)newIssue).newLocation()));
        this.populateSecondaryLocations(secondaryLocations, () -> ((NewIssue)newIssue).newLocation(), arg_0 -> ((NewIssue)newIssue).addLocation(arg_0));
        newIssue.save();
    }

    private static NewIssueLocation createPrimaryLocation(InputFile inputFile, Location primaryLocation, Supplier<NewIssueLocation> newIssueLocationSupplier) {
        NewIssueLocation newIssueLocation = newIssueLocationSupplier.get().on((InputComponent)inputFile).at(inputFile.newRange(primaryLocation.getStartLine(), primaryLocation.getStartColumn(), primaryLocation.getEndLine(), primaryLocation.getEndColumn()));
        String message = primaryLocation.getMessage();
        if (message != null) {
            newIssueLocation.message(message);
        }
        return newIssueLocation;
    }

    private void populateSecondaryLocations(Collection<Location> secondaryLocations, Supplier<NewIssueLocation> newIssueLocationProvider, Consumer<NewIssueLocation> newIssueLocationConsumer) {
        for (Location secondaryLocation : secondaryLocations) {
            InputFile inputFile = this.context.fileSystem().inputFile(this.context.fileSystem().predicates().hasAbsolutePath(secondaryLocation.getAbsolutePath()));
            if (inputFile == null) continue;
            NewIssueLocation newIssueLocation = newIssueLocationProvider.get().on((InputComponent)inputFile).at(inputFile.newRange(secondaryLocation.getStartLine(), secondaryLocation.getStartColumn(), secondaryLocation.getEndLine(), secondaryLocation.getEndColumn()));
            String secondaryLocationMessage = secondaryLocation.getMessage();
            if (secondaryLocationMessage != null) {
                newIssueLocation.message(secondaryLocationMessage);
            }
            newIssueLocationConsumer.accept(newIssueLocation);
        }
    }

    @Override
    public void onRule(String ruleId, @Nullable String shortDescription, @Nullable String fullDescription, String defaultLevel, @Nullable String category) {
        if (this.ignoreThirdPartyIssues || this.repositoryKeyByRoslynRuleKey.containsKey(ruleId)) {
            return;
        }
        this.defaultLevelByRuleId.put(ruleId, defaultLevel);
        RuleType ruleType = this.mapRuleType(category, defaultLevel);
        this.ruleTypeByRuleId.put(ruleId, ruleType);
        this.context.newAdHocRule().engineId(EXTERNAL_ENGINE_ID).ruleId(ruleId).severity(SarifParserCallbackImpl.mapSeverity(defaultLevel)).name(shortDescription != null ? shortDescription : ruleId).description(fullDescription != null ? fullDescription : null).type(ruleType).save();
    }

    private RuleType mapRuleType(@Nullable String category, String defaultLevel) {
        if (category != null) {
            if (this.bugCategories.contains(category)) {
                return RuleType.BUG;
            }
            if (this.codeSmellCategories.contains(category)) {
                return RuleType.CODE_SMELL;
            }
            if (this.vulnerabilityCategories.contains(category)) {
                return RuleType.VULNERABILITY;
            }
        }
        return "Error".equalsIgnoreCase(defaultLevel) ? RuleType.BUG : RuleType.CODE_SMELL;
    }

    private static Severity mapSeverity(String defaultLevel) {
        switch (defaultLevel.toLowerCase(Locale.ENGLISH)) {
            case "error": {
                return Severity.CRITICAL;
            }
            case "warning": {
                return Severity.MAJOR;
            }
        }
        return Severity.INFO;
    }

    private static class Issue {
        private String ruleId;
        private String moduleId;
        private String absolutePath;
        private int startLine;
        private int startColumn;
        private int endLine;
        private int endColumn;

        Issue(String ruleId, String moduleOrPath, boolean isModuleId) {
            this.ruleId = ruleId;
            if (isModuleId) {
                this.moduleId = moduleOrPath;
                this.absolutePath = "";
            } else {
                this.absolutePath = moduleOrPath;
            }
        }

        Issue(String ruleId, Location location) {
            this.ruleId = ruleId;
            this.absolutePath = location.getAbsolutePath();
            this.startLine = location.getStartLine();
            this.startColumn = location.getStartColumn();
            this.endLine = location.getEndLine();
            this.endColumn = location.getEndColumn();
        }

        public int hashCode() {
            return Objects.hash(this.ruleId, this.moduleId, this.absolutePath, this.startLine, this.startColumn, this.endLine, this.endColumn);
        }

        public boolean equals(Object other) {
            if (!(other instanceof Issue)) {
                return false;
            }
            Issue o = (Issue)other;
            return Objects.equals(this.ruleId, o.ruleId) && Objects.equals(this.moduleId, o.moduleId) && Objects.equals(this.startLine, o.startLine) && Objects.equals(this.startColumn, o.startColumn) && Objects.equals(this.endLine, o.endLine) && Objects.equals(this.endColumn, o.endColumn) && Paths.get(this.absolutePath, new String[0]).equals(Paths.get(o.absolutePath, new String[0]));
        }
    }
}

