/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.dotnet.shared.plugins;

import java.nio.file.Path;
import java.util.List;
import org.sonar.api.batch.fs.InputFile;
import org.sonar.api.batch.fs.InputFileFilter;
import org.sonarsource.dotnet.shared.plugins.AbstractConfiguration;
import org.sonarsource.dotnet.shared.plugins.EncodingPerFile;

public class WrongEncodingFileFilter
implements InputFileFilter {
    private final AbstractConfiguration config;
    private final EncodingPerFile encodingPerFile;
    private boolean skipFilter = false;
    private boolean init;

    public WrongEncodingFileFilter(EncodingPerFile encodingPerFile, AbstractConfiguration config) {
        this.encodingPerFile = encodingPerFile;
        this.config = config;
    }

    public boolean accept(InputFile inputFile) {
        this.initOnce();
        return this.skipFilter || this.encodingPerFile.encodingMatch(inputFile);
    }

    private synchronized void initOnce() {
        if (!this.init) {
            List<Path> protobufReportPath = this.config.protobufReportPathsSilent();
            if (!protobufReportPath.isEmpty()) {
                this.encodingPerFile.init(protobufReportPath.get(0));
            } else {
                this.skipFilter = true;
            }
            this.init = true;
        }
    }
}

