/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.dotnet.shared.plugins.protobuf;

import java.util.function.Function;
import org.sonar.api.batch.ScannerSide;
import org.sonar.api.batch.sensor.SensorContext;
import org.sonar.api.issue.NoSonarFilter;
import org.sonar.api.measures.FileLinesContextFactory;
import org.sonarsource.dotnet.protobuf.SonarAnalyzer;
import org.sonarsource.dotnet.shared.plugins.protobuf.CPDTokensImporter;
import org.sonarsource.dotnet.shared.plugins.protobuf.EncodingImporter;
import org.sonarsource.dotnet.shared.plugins.protobuf.FileMetadataImporter;
import org.sonarsource.dotnet.shared.plugins.protobuf.HighlightImporter;
import org.sonarsource.dotnet.shared.plugins.protobuf.MetricsImporter;
import org.sonarsource.dotnet.shared.plugins.protobuf.RawProtobufImporter;
import org.sonarsource.dotnet.shared.plugins.protobuf.SymbolRefsImporter;

@ScannerSide
public class ProtobufImporters {
    public static final String HIGHLIGHT_OUTPUT_PROTOBUF_NAME = "token-type.pb";
    public static final String SYMBOLREFS_OUTPUT_PROTOBUF_NAME = "symrefs.pb";
    public static final String CPDTOKENS_OUTPUT_PROTOBUF_NAME = "token-cpd.pb";
    public static final String METRICS_OUTPUT_PROTOBUF_NAME = "metrics.pb";
    public static final String ENCODING_OUTPUT_PROTOBUF_NAME = "encoding.pb";
    public static final String FILEMETADATA_OUTPUT_PROTOBUF_NAME = "file-metadata.pb";

    public static RawProtobufImporter<SonarAnalyzer.TokenTypeInfo> highlightImporter(SensorContext context, Function<String, String> toRealPath) {
        return new HighlightImporter(context, toRealPath);
    }

    public static RawProtobufImporter<SonarAnalyzer.SymbolReferenceInfo> symbolRefsImporter(SensorContext context, Function<String, String> toRealPath) {
        return new SymbolRefsImporter(context, toRealPath);
    }

    public static RawProtobufImporter<SonarAnalyzer.CopyPasteTokenInfo> cpdTokensImporter(SensorContext context, Function<String, String> toRealPath) {
        return new CPDTokensImporter(context, toRealPath);
    }

    public static RawProtobufImporter<SonarAnalyzer.MetricsInfo> metricsImporter(SensorContext context, FileLinesContextFactory fileLinesContextFactory, NoSonarFilter noSonarFilter, Function<String, String> toRealPath) {
        return new MetricsImporter(context, fileLinesContextFactory, noSonarFilter, toRealPath);
    }

    public static EncodingImporter encodingImporter() {
        return new EncodingImporter();
    }

    public FileMetadataImporter fileMetadataImporter() {
        return new FileMetadataImporter();
    }
}

