/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.dotnet.shared.plugins;

import com.google.gson.Gson;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.sonar.api.rules.RuleType;
import org.sonar.api.scanner.ScannerSide;
import org.sonar.api.server.rule.RulesDefinition;
import org.sonar.api.server.rule.RulesDefinitionXmlLoader;

@ScannerSide
public abstract class AbstractRulesDefinition
implements RulesDefinition {
    private static final Gson GSON = new Gson();
    private final String repositoryKey;
    private final String repositoryName;
    private final String languageKey;
    private final String rulesXmlFilePath;

    protected AbstractRulesDefinition(String repositoryKey, String repositoryName, String languageKey, String rulesXmlFilePath) {
        this.repositoryKey = repositoryKey;
        this.repositoryName = repositoryName;
        this.languageKey = languageKey;
        this.rulesXmlFilePath = rulesXmlFilePath;
    }

    public void define(RulesDefinition.Context context) {
        RulesDefinition.NewRepository repository = context.createRepository(this.repositoryKey, this.languageKey).setName(this.repositoryName);
        RulesDefinitionXmlLoader loader = new RulesDefinitionXmlLoader();
        loader.load(repository, (Reader)new InputStreamReader(this.getClass().getResourceAsStream(this.rulesXmlFilePath), StandardCharsets.UTF_8));
        this.setupHotspotRules(repository.rules());
        repository.done();
    }

    private void setupHotspotRules(Collection<RulesDefinition.NewRule> rules) {
        Map<RulesDefinition.NewRule, RuleMetadata> allRuleMetadata = rules.stream().collect(Collectors.toMap(rule -> rule, rule -> this.readRuleMetadata(rule.key())));
        Set<RulesDefinition.NewRule> hotspotRules = AbstractRulesDefinition.getHotspotRules(allRuleMetadata);
        allRuleMetadata.forEach(AbstractRulesDefinition::updateSecurityStandards);
        hotspotRules.forEach(rule -> rule.setType(RuleType.SECURITY_HOTSPOT));
    }

    private static Set<RulesDefinition.NewRule> getHotspotRules(Map<RulesDefinition.NewRule, RuleMetadata> allRuleMetadata) {
        return allRuleMetadata.entrySet().stream().filter(entry -> ((RuleMetadata)entry.getValue()).isSecurityHotspot()).map(Map.Entry::getKey).collect(Collectors.toSet());
    }

    private static void updateSecurityStandards(RulesDefinition.NewRule rule, RuleMetadata ruleMetadata) {
        for (String s : ruleMetadata.securityStandards.OWASP) {
            rule.addOwaspTop10(new RulesDefinition.OwaspTop10[]{RulesDefinition.OwaspTop10.valueOf((String)s)});
        }
        rule.addCwe(ruleMetadata.securityStandards.CWE);
    }

    private RuleMetadata readRuleMetadata(String ruleKey) {
        RuleMetadata ruleMetadata;
        block8: {
            String resourcePath = this.getRuleJson(ruleKey);
            InputStream stream = AbstractRulesDefinition.class.getResourceAsStream(resourcePath);
            try {
                RuleMetadata ruleMetadata2 = ruleMetadata = stream != null ? (RuleMetadata)GSON.fromJson((Reader)new InputStreamReader(stream, StandardCharsets.UTF_8), RuleMetadata.class) : new RuleMetadata();
                if (stream == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (stream != null) {
                        try {
                            stream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new IllegalStateException("Failed to read: " + resourcePath, e);
                }
            }
            stream.close();
        }
        return ruleMetadata;
    }

    protected abstract String getRuleJson(String var1);

    private static class SecurityStandards {
        int[] CWE = new int[0];
        String[] OWASP = new String[0];

        private SecurityStandards() {
        }
    }

    private static class RuleMetadata {
        private static final String SECURITY_HOTSPOT = "SECURITY_HOTSPOT";
        String sqKey;
        String type;
        SecurityStandards securityStandards = new SecurityStandards();

        private RuleMetadata() {
        }

        String getKey() {
            return this.sqKey;
        }

        boolean isSecurityHotspot() {
            return SECURITY_HOTSPOT.equals(this.type);
        }
    }
}

