/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.dotnet.shared.plugins.protobuf;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.function.UnaryOperator;
import javax.annotation.CheckForNull;
import org.sonar.api.batch.fs.InputFile;
import org.sonar.api.batch.sensor.SensorContext;
import org.sonar.api.batch.sensor.highlighting.NewHighlighting;
import org.sonar.api.batch.sensor.highlighting.TypeOfText;
import org.sonarsource.dotnet.protobuf.SonarAnalyzer;
import org.sonarsource.dotnet.shared.plugins.SensorContextUtils;
import org.sonarsource.dotnet.shared.plugins.protobuf.ProtobufImporter;

class HighlightImporter
extends ProtobufImporter<SonarAnalyzer.TokenTypeInfo> {
    private final SensorContext context;
    private final Map<InputFile, HashSet<SonarAnalyzer.TokenTypeInfo.TokenInfo>> fileHighlights = new HashMap<InputFile, HashSet<SonarAnalyzer.TokenTypeInfo.TokenInfo>>();

    HighlightImporter(SensorContext context, UnaryOperator<String> toRealPath) {
        super(SonarAnalyzer.TokenTypeInfo.parser(), context, SonarAnalyzer.TokenTypeInfo::getFilePath, toRealPath);
        this.context = context;
    }

    @Override
    void consumeFor(InputFile inputFile, SonarAnalyzer.TokenTypeInfo message) {
        for (SonarAnalyzer.TokenTypeInfo.TokenInfo tokenInfo : message.getTokenInfoList()) {
            this.fileHighlights.computeIfAbsent(inputFile, f -> new HashSet()).add(tokenInfo);
        }
    }

    @Override
    public void save() {
        for (Map.Entry<InputFile, HashSet<SonarAnalyzer.TokenTypeInfo.TokenInfo>> entry : this.fileHighlights.entrySet()) {
            NewHighlighting highlighting = this.context.newHighlighting().onFile(entry.getKey());
            boolean foundMappableHighlightings = false;
            for (SonarAnalyzer.TokenTypeInfo.TokenInfo message : entry.getValue()) {
                TypeOfText typeOfText = HighlightImporter.toType(message.getTokenType());
                if (typeOfText == null) continue;
                highlighting.highlight(SensorContextUtils.toTextRange(entry.getKey(), message.getTextRange()), typeOfText);
                foundMappableHighlightings = true;
            }
            if (!foundMappableHighlightings) continue;
            highlighting.save();
        }
    }

    @Override
    boolean isProcessed(InputFile inputFile) {
        return false;
    }

    @CheckForNull
    private static TypeOfText toType(SonarAnalyzer.TokenType tokenType) {
        switch (tokenType) {
            case NUMERIC_LITERAL: {
                return TypeOfText.CONSTANT;
            }
            case COMMENT: {
                return TypeOfText.COMMENT;
            }
            case KEYWORD: {
                return TypeOfText.KEYWORD;
            }
            case TYPE_NAME: {
                return TypeOfText.KEYWORD_LIGHT;
            }
            case STRING_LITERAL: {
                return TypeOfText.STRING;
            }
        }
        return null;
    }
}

