/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.dotnet.tests;

import java.io.File;
import java.util.Map;
import java.util.Set;
import org.sonar.api.batch.fs.FilePredicates;
import org.sonar.api.batch.fs.InputFile;
import org.sonar.api.batch.sensor.SensorContext;
import org.sonar.api.batch.sensor.SensorDescriptor;
import org.sonar.api.batch.sensor.coverage.NewCoverage;
import org.sonar.api.config.Configuration;
import org.sonar.api.scanner.sensor.ProjectSensor;
import org.sonar.api.utils.log.Logger;
import org.sonar.api.utils.log.Loggers;
import org.sonar.plugins.dotnet.tests.BranchCoverage;
import org.sonar.plugins.dotnet.tests.Coverage;
import org.sonar.plugins.dotnet.tests.CoverageAggregator;
import org.sonar.plugins.dotnet.tests.CoverageConfiguration;
import org.sonar.plugins.dotnet.tests.WildcardPatternFileProvider;

public class CoverageReportImportSensor
implements ProjectSensor {
    static final File BASE_DIR = new File(".");
    private static final Logger LOG = Loggers.get(CoverageReportImportSensor.class);
    private final WildcardPatternFileProvider wildcardPatternFileProvider = new WildcardPatternFileProvider(BASE_DIR);
    private final CoverageConfiguration coverageConf;
    private final CoverageAggregator coverageAggregator;
    private final boolean isIntegrationTest;
    private final String languageKey;
    private final String languageName;

    public CoverageReportImportSensor(CoverageConfiguration coverageConf, CoverageAggregator coverageAggregator, String languageKey, String languageName, boolean isIntegrationTest) {
        this.coverageConf = coverageConf;
        this.coverageAggregator = coverageAggregator;
        this.isIntegrationTest = isIntegrationTest;
        this.languageKey = languageKey;
        this.languageName = languageName;
    }

    public void describe(SensorDescriptor descriptor) {
        if (this.isIntegrationTest) {
            descriptor.name("[Deprecated] " + this.languageName + " Integration Tests Coverage Report Import");
        } else {
            descriptor.name(this.languageName + " Tests Coverage Report Import");
        }
        descriptor.onlyWhenConfiguration(c -> this.coverageAggregator.hasCoverageProperty(arg_0 -> ((Configuration)c).hasKey(arg_0)));
        descriptor.onlyOnLanguage(this.languageKey);
    }

    public void execute(SensorContext context) {
        if (!this.coverageAggregator.hasCoverageProperty()) {
            LOG.debug("No coverage property. Skip Sensor");
            return;
        }
        if (this.isIntegrationTest) {
            LOG.warn("Starting with SonarQube 6.2 separation between Unit Tests and Integration Tests Coverage reports is deprecated. Please move all reports specified from *.it.reportPaths into *.reportPaths.");
        }
        this.analyze(context, new Coverage());
    }

    void analyze(SensorContext context, Coverage coverage) {
        LOG.debug("Analyzing coverage with wildcardPatternFileProvider with base dir '{}' and file separator '{}'.", (Object)BASE_DIR.getAbsolutePath(), (Object)File.separator);
        this.coverageAggregator.aggregate(this.wildcardPatternFileProvider, coverage);
        Set<String> coverageFiles = coverage.files();
        FileCountStatistics fileCountStatistics = new FileCountStatistics(coverageFiles.size());
        LOG.debug("Analyzing coverage after aggregate found '{}' coverage files.", (Object)coverageFiles.size());
        for (String filePath : coverageFiles) {
            LOG.trace("Counting statistics for '{}'.", (Object)filePath);
            FilePredicates p = context.fileSystem().predicates();
            InputFile inputFile = context.fileSystem().inputFile(p.hasAbsolutePath(filePath));
            if (inputFile == null) {
                fileCountStatistics.projectExcluded++;
                LOG.debug("The file '{}' is either excluded or outside of your solution folder therefore Code Coverage will not be imported.", (Object)filePath);
                continue;
            }
            if (inputFile.type().equals((Object)InputFile.Type.TEST)) {
                fileCountStatistics.test++;
                LOG.debug("Skipping '{}' as it is a test file.", (Object)filePath);
                continue;
            }
            if (!this.coverageConf.languageKey().equals(inputFile.language())) {
                LOG.debug("Skipping '{}' as conf lang '{}' does not equal file lang '{}'.", new Object[]{filePath, this.coverageConf.languageKey(), inputFile.language()});
                fileCountStatistics.otherLanguageExcluded++;
                continue;
            }
            CoverageReportImportSensor.analyzeCoverage(context, coverage, fileCountStatistics, filePath, inputFile);
        }
        LOG.debug("The total number of file count statistics is '{}'.", (Object)fileCountStatistics.total);
        if (fileCountStatistics.total != 0) {
            LOG.info(fileCountStatistics.toString());
            if (fileCountStatistics.mainWithCoverage == 0) {
                LOG.warn("The Code Coverage report doesn't contain any coverage data for the included files. Troubleshooting guide: https://community.sonarsource.com/t/37151");
            }
        }
    }

    private static void analyzeCoverage(SensorContext context, Coverage coverage, FileCountStatistics fileCountStatistics, String filePath, InputFile inputFile) {
        LOG.trace("Checking main file coverage for '{}'.", (Object)filePath);
        fileCountStatistics.main++;
        boolean fileHasCoverage = false;
        NewCoverage newCoverage = context.newCoverage().onFile(inputFile);
        for (Map.Entry<Integer, Integer> entry : coverage.hits(filePath).entrySet()) {
            LOG.trace("Found entry with key '{}' and value '{}'.", (Object)entry.getKey(), (Object)entry.getValue());
            fileHasCoverage = true;
            newCoverage.lineHits(entry.getKey().intValue(), entry.getValue().intValue());
        }
        for (BranchCoverage branchCoverage : coverage.getBranchCoverage(filePath)) {
            LOG.trace("Found branch coverage entry on line '{}', with total conditions '{}' and covered conditions '{}'.", new Object[]{branchCoverage.getLine(), branchCoverage.getConditions(), branchCoverage.getCoveredConditions()});
            fileHasCoverage = true;
            newCoverage.conditions(branchCoverage.getLine(), branchCoverage.getConditions(), branchCoverage.getCoveredConditions());
        }
        newCoverage.save();
        if (fileHasCoverage) {
            fileCountStatistics.mainWithCoverage++;
            LOG.trace("Found some coverage info for the file '{}'.", (Object)filePath);
        } else {
            LOG.debug("No coverage info found for the file '{}'.", (Object)filePath);
        }
    }

    private static class FileCountStatistics {
        private final int total;
        private int main = 0;
        private int mainWithCoverage = 0;
        private int test = 0;
        private int projectExcluded = 0;
        private int otherLanguageExcluded = 0;

        private FileCountStatistics(int total) {
            this.total = total;
        }

        public String toString() {
            return "Coverage Report Statistics: " + this.total + " files, " + this.main + " main files, " + this.mainWithCoverage + " main files with coverage, " + this.test + " test files, " + this.projectExcluded + " project excluded files, " + this.otherLanguageExcluded + " other language files.";
        }
    }
}

