/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.dotnet.shared.plugins;

import com.google.gson.Gson;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.Type;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Locale;
import java.util.stream.Collectors;
import org.sonar.api.SonarRuntime;
import org.sonar.api.rule.RuleStatus;
import org.sonar.api.rules.RuleType;
import org.sonar.api.scanner.ScannerSide;
import org.sonar.api.server.debt.DebtRemediationFunction;
import org.sonar.api.server.rule.RuleParamType;
import org.sonar.api.server.rule.RulesDefinition;
import org.sonar.api.utils.Version;

@ScannerSide
public abstract class AbstractRulesDefinition
implements RulesDefinition {
    private static final String REPOSITORY_NAME = "SonarAnalyzer";
    private static final Gson GSON = new Gson();
    private final String repositoryKey;
    private final String languageKey;
    private final String resourcesDirectory;
    private final String metadataSuffix;
    private final boolean isOwaspByVersionSupported;

    protected AbstractRulesDefinition(String repositoryKey, String languageKey, SonarRuntime sonarRuntime, String resourcesDirectory, String metadataSuffix) {
        this.repositoryKey = repositoryKey;
        this.languageKey = languageKey;
        this.resourcesDirectory = resourcesDirectory;
        this.metadataSuffix = metadataSuffix;
        this.isOwaspByVersionSupported = sonarRuntime.getApiVersion().isGreaterThanOrEqual(Version.create((int)9, (int)3));
    }

    public void define(RulesDefinition.Context context) {
        RulesDefinition.NewRepository repository = context.createRepository(this.repositoryKey, this.languageKey).setName(REPOSITORY_NAME);
        Type ruleListType = new TypeToken<List<Rule>>(){}.getType();
        List rules = (List)GSON.fromJson(this.readResource("Rules.json"), ruleListType);
        for (Rule rule : rules) {
            RulesDefinition.NewRule newRule = repository.createRule(rule.id);
            this.configureRule(newRule, this.loadMetadata(rule.id), rule.parameters);
            newRule.setHtmlDescription(this.readResource(rule.id + this.metadataSuffix + ".html"));
        }
        repository.done();
    }

    private void configureRule(RulesDefinition.NewRule rule, RuleMetadata metadata, RuleParameter[] parameters) {
        rule.setName(metadata.title).setType(RuleType.valueOf((String)metadata.type)).setStatus(RuleStatus.valueOf((String)metadata.status.toUpperCase(Locale.ROOT))).setSeverity(metadata.defaultSeverity.toUpperCase(Locale.ROOT)).setTags(metadata.tags);
        if (metadata.remediation != null) {
            rule.setDebtRemediationFunction(metadata.remediation.remediationFunction(rule));
            rule.setGapDescription(metadata.remediation.linearDesc);
        }
        for (RuleParameter param : parameters) {
            rule.createParam(param.key).setType(RuleParamType.parse((String)param.type)).setDescription(param.description).setDefaultValue(param.defaultValue);
        }
        this.addSecurityStandards(rule, metadata.securityStandards);
    }

    private void addSecurityStandards(RulesDefinition.NewRule rule, SecurityStandards securityStandards) {
        for (String s : securityStandards.owasp2017) {
            rule.addOwaspTop10(new RulesDefinition.OwaspTop10[]{RulesDefinition.OwaspTop10.valueOf((String)s)});
        }
        if (this.isOwaspByVersionSupported) {
            for (String s : securityStandards.owasp2021) {
                rule.addOwaspTop10(RulesDefinition.OwaspTop10Version.Y2021, new RulesDefinition.OwaspTop10[]{RulesDefinition.OwaspTop10.valueOf((String)s)});
            }
        }
        rule.addCwe(securityStandards.cwe);
    }

    private RuleMetadata loadMetadata(String id) {
        return (RuleMetadata)GSON.fromJson(this.readResource(id + this.metadataSuffix + ".json"), RuleMetadata.class);
    }

    private String readResource(String name) {
        String string;
        InputStream stream = this.getResourceAsStream(this.resourcesDirectory + name);
        if (stream == null) {
            throw new IllegalStateException("Resource does not exist: " + name);
        }
        BufferedReader reader = new BufferedReader(new InputStreamReader(stream, StandardCharsets.UTF_8));
        try {
            string = reader.lines().collect(Collectors.joining("\n"));
        }
        catch (Throwable throwable) {
            try {
                try {
                    reader.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new IllegalStateException("Failed to read: " + name, e);
            }
        }
        reader.close();
        return string;
    }

    InputStream getResourceAsStream(String name) {
        return this.getClass().getResourceAsStream(name);
    }

    private static class SecurityStandards {
        @SerializedName(value="CWE")
        int[] cwe = new int[0];
        @SerializedName(value="OWASP Top 10 2021")
        String[] owasp2021 = new String[0];
        @SerializedName(value="OWASP")
        String[] owasp2017 = new String[0];

        private SecurityStandards() {
        }
    }

    private static class Remediation {
        String func;
        String constantCost;
        String linearDesc;
        String linearOffset;
        String linearFactor;

        private Remediation() {
        }

        public DebtRemediationFunction remediationFunction(RulesDefinition.NewRule rule) {
            if (this.func.startsWith("Constant")) {
                return rule.debtRemediationFunctions().constantPerIssue(this.constantCost);
            }
            if ("Linear".equals(this.func)) {
                return rule.debtRemediationFunctions().linear(this.linearFactor);
            }
            return rule.debtRemediationFunctions().linearWithOffset(this.linearFactor, this.linearOffset);
        }
    }

    static class RuleMetadata {
        String title;
        String status;
        String type;
        String[] tags;
        String defaultSeverity;
        Remediation remediation;
        SecurityStandards securityStandards = new SecurityStandards();

        RuleMetadata() {
        }
    }

    private static class RuleParameter {
        String key;
        String description;
        String type;
        String defaultValue;

        private RuleParameter() {
        }
    }

    private static class Rule {
        String id;
        RuleParameter[] parameters;

        private Rule() {
        }
    }
}

