/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.dotnet.shared.plugins;

import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.reflect.Type;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import org.sonar.api.batch.sensor.SensorContext;
import org.sonar.api.batch.sensor.SensorDescriptor;
import org.sonar.api.config.Configuration;
import org.sonar.api.notifications.AnalysisWarnings;
import org.sonar.api.scanner.sensor.ProjectSensor;
import org.sonar.api.utils.log.Logger;
import org.sonar.api.utils.log.Loggers;

public final class AnalysisWarningsSensor
implements ProjectSensor {
    private static final Logger LOG = Loggers.get(AnalysisWarningsSensor.class);
    private static final String SUFFIX = ".sonar";
    private static final Gson GSON = new Gson();
    private static final Pattern AnalysisWarningsPattern = Pattern.compile("AnalysisWarnings\\..*\\.json");
    private final Configuration configuration;
    private final AnalysisWarnings analysisWarnings;

    public AnalysisWarningsSensor(Configuration configuration, AnalysisWarnings analysisWarnings) {
        this.configuration = configuration;
        this.analysisWarnings = analysisWarnings;
    }

    public void describe(SensorDescriptor descriptor) {
        descriptor.name("Analysis Warnings import");
    }

    public void execute(SensorContext sensorContext) {
        this.configuration.get("sonar.working.directory").filter(s -> s.endsWith(SUFFIX)).map(AnalysisWarningsSensor::getOutputDir).map(AnalysisWarningsSensor::getFilePaths).ifPresent(this::publishMessages);
    }

    private static Path getOutputDir(String workingDirectory) {
        return Paths.get(workingDirectory, new String[0]).getParent();
    }

    private static Stream<Path> getFilePaths(Path outputDirectory) {
        LOG.debug("Searching for analysis warnings in " + outputDirectory);
        try {
            return Files.find(outputDirectory, 1, (path, attributes) -> AnalysisWarningsPattern.matcher(path.toFile().getName()).matches(), new FileVisitOption[0]);
        }
        catch (IOException exception) {
            LOG.warn("Error occurred while loading analysis analysis warnings", (Throwable)exception);
            return Stream.empty();
        }
    }

    private void publishMessages(Stream<Path> paths) {
        Type collectionType = new TypeToken<List<Warning>>(){}.getType();
        paths.forEach(path -> {
            LOG.debug("Loading analysis warnings from " + path.toAbsolutePath());
            try (InputStream is = Files.newInputStream(path, new OpenOption[0]);){
                List warnings = (List)GSON.fromJson((Reader)new InputStreamReader(is, StandardCharsets.UTF_8), collectionType);
                warnings.forEach(message -> this.analysisWarnings.addUnique(message.getText()));
            }
            catch (Exception exception) {
                LOG.error("Error occurred while publishing analysis warnings", (Throwable)exception);
            }
        });
    }

    private static class Warning {
        private String text = "";

        private Warning() {
        }

        public String getText() {
            return this.text;
        }
    }
}

