/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.dotnet.shared.plugins.protobuf;

import java.util.ArrayList;
import java.util.List;
import org.sonar.api.utils.log.Logger;
import org.sonar.api.utils.log.Loggers;
import org.sonarsource.dotnet.protobuf.SonarAnalyzer;
import org.sonarsource.dotnet.shared.plugins.protobuf.RawProtobufImporter;

public class LogImporter
extends RawProtobufImporter<SonarAnalyzer.LogInfo> {
    private static final Logger LOG = Loggers.get(LogImporter.class);
    private List<SonarAnalyzer.LogInfo> messages = new ArrayList<SonarAnalyzer.LogInfo>();

    public LogImporter() {
        super(SonarAnalyzer.LogInfo.parser());
    }

    @Override
    void consume(SonarAnalyzer.LogInfo message) {
        this.messages.add(message);
    }

    @Override
    public void save() {
        block5: for (SonarAnalyzer.LogInfo message : this.messages) {
            switch (message.getSeverity()) {
                case DEBUG: {
                    LOG.debug(message.getText());
                    continue block5;
                }
                case INFO: {
                    LOG.info(message.getText());
                    continue block5;
                }
                case WARNING: {
                    LOG.warn(message.getText());
                    continue block5;
                }
            }
            LOG.warn("Unexpected log message severity: " + (Object)((Object)message.getSeverity()));
            LOG.info(message.getText());
        }
        this.messages.clear();
    }
}

