/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.dotnet.shared.plugins;

import java.net.URI;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Optional;
import org.sonar.api.SonarRuntime;
import org.sonar.api.batch.fs.FileSystem;
import org.sonar.api.batch.sensor.SensorContext;
import org.sonar.api.batch.sensor.SensorDescriptor;
import org.sonar.api.batch.sensor.cache.WriteCache;
import org.sonar.api.config.Configuration;
import org.sonar.api.resources.AbstractLanguage;
import org.sonar.api.scanner.ScannerSide;
import org.sonar.api.scanner.sensor.ProjectSensor;
import org.sonar.api.utils.Version;
import org.sonar.api.utils.log.Logger;
import org.sonar.api.utils.log.Loggers;
import org.sonarsource.dotnet.shared.plugins.AbstractPropertyDefinitions;
import org.sonarsource.dotnet.shared.plugins.HashProvider;

@ScannerSide
public abstract class AbstractFileCacheSensor
implements ProjectSensor {
    private static final Logger LOG = Loggers.get(AbstractFileCacheSensor.class);
    private final AbstractLanguage language;
    private final HashProvider hashProvider;
    private final SonarRuntime runtime;

    protected AbstractFileCacheSensor(AbstractLanguage language, HashProvider hashProvider, SonarRuntime runtime) {
        this.language = language;
        this.hashProvider = hashProvider;
        this.runtime = runtime;
    }

    public void describe(SensorDescriptor descriptor) {
        descriptor.name(this.language.getName() + " File Caching Sensor");
        descriptor.onlyOnLanguage(this.language.getKey());
    }

    public void execute(SensorContext context) {
        Configuration configuration = context.config();
        if (configuration.get(AbstractPropertyDefinitions.getPullRequestBase()).isPresent()) {
            LOG.debug("Incremental PR analysis: Cache is not uploaded for pull requests.");
            return;
        }
        if (!this.runtime.getApiVersion().isGreaterThanOrEqual(Version.create((int)9, (int)4))) {
            LOG.info("Incremental PR analysis is supported only starting with SonarQube 9.4.");
            return;
        }
        if (!context.isCacheEnabled()) {
            LOG.info("Incremental PR analysis: Analysis cache is disabled.");
            return;
        }
        Optional<URI> basePath = configuration.get(AbstractPropertyDefinitions.getPullRequestCacheBasePath()).map(x -> Paths.get(x, new String[0]).toUri());
        if (basePath.isEmpty()) {
            LOG.warn("Incremental PR analysis: Could not determine common base path, cache will not be computed. Consider setting 'sonar.projectBaseDir' property.");
            return;
        }
        LOG.debug("Incremental PR analysis: Preparing to upload file hashes.");
        FileSystem fileSystem = context.fileSystem();
        fileSystem.inputFiles(fileSystem.predicates().hasLanguage(this.language.getKey())).forEach(inputFile -> {
            URI uri = inputFile.uri();
            String key = ((URI)basePath.get()).relativize(uri).getPath().replace('\\', '/');
            WriteCache next = context.nextCache();
            try {
                LOG.debug("Incremental PR analysis: Adding hash for '" + key + "' to the cache.");
                next.write(key, this.hashProvider.computeHash(Path.of(uri)));
            }
            catch (Exception exception) {
                LOG.warn("Incremental PR analysis: An error occurred while computing the hash for " + key, (Throwable)exception);
            }
        });
    }
}

