/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.dotnet.shared.plugins;

import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.Type;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.stream.Collectors;
import org.sonar.api.SonarRuntime;
import org.sonar.api.scanner.ScannerSide;
import org.sonar.api.server.rule.RuleParamType;
import org.sonar.api.server.rule.RulesDefinition;
import org.sonarsource.analyzer.commons.RuleMetadataLoader;

@ScannerSide
public abstract class AbstractRulesDefinition
implements RulesDefinition {
    private static final String REPOSITORY_NAME = "SonarAnalyzer";
    private static final Gson GSON = new Gson();
    private final String repositoryKey;
    private final String languageKey;
    private final SonarRuntime sonarRuntime;

    protected AbstractRulesDefinition(String repositoryKey, String languageKey, SonarRuntime sonarRuntime) {
        this.repositoryKey = repositoryKey;
        this.languageKey = languageKey;
        this.sonarRuntime = sonarRuntime;
    }

    protected abstract String getResourcesDirectory();

    public void define(RulesDefinition.Context context) {
        Type ruleListType = new TypeToken<List<Rule>>(){}.getType();
        List rules = (List)GSON.fromJson(this.readResource("Rules.json"), ruleListType);
        RulesDefinition.NewRepository repository = context.createRepository(this.repositoryKey, this.languageKey).setName(REPOSITORY_NAME);
        RuleMetadataLoader ruleMetadataLoader = new RuleMetadataLoader(this.getResourcesDirectory(), this.sonarRuntime);
        ruleMetadataLoader.addRulesByRuleKey(repository, rules.stream().map(Rule::getId).toList());
        for (Rule rule : rules) {
            RulesDefinition.NewRule currentRule = repository.rule(rule.id);
            if (currentRule == null) continue;
            for (RuleParameter param : rule.parameters) {
                currentRule.createParam(param.key).setType(RuleParamType.parse((String)param.type)).setDescription(param.description).setDefaultValue(param.defaultValue);
            }
        }
        repository.done();
    }

    private String readResource(String name) {
        String string;
        InputStream stream = this.getResourceAsStream(this.getResourcesDirectory() + "/" + name);
        if (stream == null) {
            throw new IllegalStateException("Resource does not exist: " + name);
        }
        BufferedReader reader = new BufferedReader(new InputStreamReader(stream, StandardCharsets.UTF_8));
        try {
            string = reader.lines().collect(Collectors.joining("\n"));
        }
        catch (Throwable throwable) {
            try {
                try {
                    reader.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new IllegalStateException("Failed to read: " + name, e);
            }
        }
        reader.close();
        return string;
    }

    InputStream getResourceAsStream(String name) {
        return this.getClass().getResourceAsStream(name);
    }

    private static class Rule {
        String id;
        RuleParameter[] parameters;

        private Rule() {
        }

        public String getId() {
            return this.id;
        }
    }

    private static class RuleParameter {
        String key;
        String description;
        String type;
        String defaultValue;

        private RuleParameter() {
        }
    }
}

