/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.dotnet.shared.plugins;

import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonar.api.batch.fs.InputFile;
import org.sonar.api.scanner.ScannerSide;
import org.sonarsource.dotnet.shared.plugins.AbstractGlobalProtobufFileProcessor;

@ScannerSide
public class EncodingPerFile {
    private static final Logger LOG = LoggerFactory.getLogger(EncodingPerFile.class);
    private final AbstractGlobalProtobufFileProcessor globalReportProcessor;

    public EncodingPerFile(AbstractGlobalProtobufFileProcessor globalReportProcessor) {
        this.globalReportProcessor = globalReportProcessor;
    }

    boolean encodingMatch(InputFile inputFile) {
        String uri = inputFile.uri().toString();
        if (!this.globalReportProcessor.getRoslynEncodingPerUri().containsKey(uri)) {
            return true;
        }
        Charset roslynEncoding = this.globalReportProcessor.getRoslynEncodingPerUri().get(uri);
        if (roslynEncoding == null) {
            LOG.warn("Roslyn can not detect encoding for '{}', using default instead.", (Object)uri);
            return true;
        }
        Charset sqEncoding = inputFile.charset();
        boolean sameEncoding = sqEncoding.equals(roslynEncoding);
        if (!sameEncoding) {
            if (sqEncoding.equals(StandardCharsets.UTF_16LE) && roslynEncoding.equals(StandardCharsets.UTF_16)) {
                sameEncoding = true;
            } else {
                LOG.warn("Encoding detected by Roslyn and encoding used by SonarQube do not match for file {}. SonarQube encoding is '{}', Roslyn encoding is '{}'. File will be skipped.", new Object[]{uri, sqEncoding, roslynEncoding});
            }
        }
        return sameEncoding;
    }
}

