/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.dotnet.shared.plugins;

import java.nio.file.Paths;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonar.api.batch.fs.InputComponent;
import org.sonar.api.batch.fs.InputFile;
import org.sonar.api.batch.rule.Severity;
import org.sonar.api.batch.sensor.SensorContext;
import org.sonar.api.batch.sensor.issue.NewExternalIssue;
import org.sonar.api.batch.sensor.issue.NewIssue;
import org.sonar.api.batch.sensor.issue.NewIssueLocation;
import org.sonar.api.rule.RuleKey;
import org.sonar.api.rules.RuleType;
import org.sonar.api.scanner.fs.InputProject;
import org.sonarsource.dotnet.shared.sarif.Location;
import org.sonarsource.dotnet.shared.sarif.SarifParserCallback;

public class SarifParserCallbackImpl
implements SarifParserCallback {
    private static final Logger LOG = LoggerFactory.getLogger(SarifParserCallbackImpl.class);
    private static final String EXTERNAL_ENGINE_ID = "roslyn";
    private static final List<String> OWN_REPOSITORIES = Arrays.asList("csharpsquid", "vbnet");
    private final SensorContext context;
    private final Map<String, String> repositoryKeyByRoslynRuleKey;
    private final Set<Issue> savedIssues = new HashSet<Issue>();
    private final boolean ignoreThirdPartyIssues;
    private final Set<String> bugCategories;
    private final Set<String> codeSmellCategories;
    private final Set<String> vulnerabilityCategories;
    private final Map<String, String> defaultLevelByRuleId = new HashMap<String, String>();
    private final Map<String, RuleType> ruleTypeByRuleId = new HashMap<String, RuleType>();

    public SarifParserCallbackImpl(SensorContext context, Map<String, String> repositoryKeyByRoslynRuleKey, boolean ignoreThirdPartyIssues, Set<String> bugCategories, Set<String> codeSmellCategories, Set<String> vulnerabilityCategories) {
        this.context = context;
        this.repositoryKeyByRoslynRuleKey = repositoryKeyByRoslynRuleKey;
        this.ignoreThirdPartyIssues = ignoreThirdPartyIssues;
        this.bugCategories = bugCategories;
        this.codeSmellCategories = codeSmellCategories;
        this.vulnerabilityCategories = vulnerabilityCategories;
    }

    @Override
    public void onProjectIssue(String ruleId, @Nullable String level, InputProject inputProject, String message) {
        Issue issue = new Issue(ruleId, inputProject.toString(), true);
        if (!this.savedIssues.add(issue)) {
            return;
        }
        String repositoryKey = this.repositoryKeyByRoslynRuleKey.get(ruleId);
        if (repositoryKey != null) {
            this.createProjectLevelIssue(ruleId, inputProject, message, repositoryKey);
        }
    }

    private void createProjectLevelIssue(String ruleId, InputProject inputProject, String message, String repositoryKey) {
        this.logIssue("project level", ruleId, inputProject.toString());
        NewIssue newIssue = this.context.newIssue();
        newIssue.forRule(RuleKey.of((String)repositoryKey, (String)ruleId)).at(newIssue.newLocation().on((InputComponent)inputProject).message(message)).save();
    }

    @Override
    public void onFileIssue(String ruleId, @Nullable String level, String absolutePath, Collection<Location> secondaryLocations, String message) {
        Issue issue = new Issue(ruleId, absolutePath, false);
        if (!this.savedIssues.add(issue)) {
            return;
        }
        InputFile inputFile = this.context.fileSystem().inputFile(this.context.fileSystem().predicates().hasAbsolutePath(absolutePath));
        if (inputFile == null) {
            this.logMissingInputFile(ruleId, absolutePath);
            return;
        }
        String repositoryKey = this.repositoryKeyByRoslynRuleKey.get(ruleId);
        if (repositoryKey != null) {
            this.createFileLevelIssue(ruleId, message, repositoryKey, inputFile, secondaryLocations);
        } else if (this.shouldCreateExternalIssue(ruleId)) {
            this.createFileLevelExternalIssue(ruleId, level, message, inputFile, secondaryLocations);
        }
    }

    private void createFileLevelIssue(String ruleId, String message, String repositoryKey, InputFile inputFile, Collection<Location> secondaryLocations) {
        this.logIssue("file level", ruleId, inputFile.toString());
        NewIssue newIssue = this.context.newIssue();
        newIssue.forRule(RuleKey.of((String)repositoryKey, (String)ruleId)).at(newIssue.newLocation().on((InputComponent)inputFile).message(message));
        this.populateSecondaryLocations(secondaryLocations, () -> ((NewIssue)newIssue).newLocation(), arg_0 -> ((NewIssue)newIssue).addLocation(arg_0), SarifParserCallbackImpl.isSonarSourceRepository(repositoryKey));
        newIssue.save();
    }

    private void createFileLevelExternalIssue(String ruleId, @Nullable String level, String message, InputFile inputFile, Collection<Location> secondaryLocations) {
        this.logIssue("file level external", ruleId, inputFile.toString());
        NewExternalIssue newIssue = this.newExternalIssue(ruleId);
        newIssue.at(newIssue.newLocation().on((InputComponent)inputFile).message(message));
        this.setExternalIssueSeverityAndType(ruleId, level, newIssue);
        this.populateSecondaryLocations(secondaryLocations, () -> ((NewExternalIssue)newIssue).newLocation(), arg_0 -> ((NewExternalIssue)newIssue).addLocation(arg_0), true);
        newIssue.save();
    }

    @Override
    public void onIssue(String ruleId, @Nullable String level, Location primaryLocation, Collection<Location> secondaryLocations) {
        Issue issue = new Issue(ruleId, primaryLocation);
        if (!this.savedIssues.add(issue)) {
            return;
        }
        InputFile inputFile = this.context.fileSystem().inputFile(this.context.fileSystem().predicates().hasAbsolutePath(primaryLocation.getAbsolutePath()));
        if (inputFile == null) {
            this.logMissingInputFile(ruleId, primaryLocation.getAbsolutePath());
            return;
        }
        String repositoryKey = this.repositoryKeyByRoslynRuleKey.get(ruleId);
        if (repositoryKey != null) {
            this.createIssue(inputFile, ruleId, primaryLocation, secondaryLocations, repositoryKey);
        } else if (this.shouldCreateExternalIssue(ruleId)) {
            this.createExternalIssue(inputFile, ruleId, level, primaryLocation, secondaryLocations);
        }
    }

    private void createExternalIssue(InputFile inputFile, String ruleId, @Nullable String level, Location primaryLocation, Collection<Location> secondaryLocations) {
        this.logIssue("external", ruleId, primaryLocation.getAbsolutePath());
        NewExternalIssue newIssue = this.newExternalIssue(ruleId);
        newIssue.at(SarifParserCallbackImpl.createPrimaryLocation(inputFile, primaryLocation, () -> ((NewExternalIssue)newIssue).newLocation(), true));
        this.setExternalIssueSeverityAndType(ruleId, level, newIssue);
        this.populateSecondaryLocations(secondaryLocations, () -> ((NewExternalIssue)newIssue).newLocation(), arg_0 -> ((NewExternalIssue)newIssue).addLocation(arg_0), true);
        newIssue.save();
    }

    private void setExternalIssueSeverityAndType(String ruleId, @Nullable String level, NewExternalIssue newIssue) {
        if (level != null) {
            newIssue.severity(SarifParserCallbackImpl.mapSeverity(level));
        } else if (this.defaultLevelByRuleId.containsKey(ruleId)) {
            newIssue.severity(SarifParserCallbackImpl.mapSeverity(this.defaultLevelByRuleId.get(ruleId)));
        } else {
            LOG.warn("Rule {} was not found in the SARIF report, assuming default severity", (Object)ruleId);
            newIssue.severity(Severity.MAJOR);
        }
        newIssue.type(Optional.ofNullable(this.ruleTypeByRuleId.get(ruleId)).orElse(RuleType.CODE_SMELL));
    }

    private NewExternalIssue newExternalIssue(String ruleId) {
        NewExternalIssue newIssue = this.context.newExternalIssue();
        newIssue.engineId(EXTERNAL_ENGINE_ID).ruleId(ruleId);
        return newIssue;
    }

    private void createIssue(InputFile inputFile, String ruleId, Location primaryLocation, Collection<Location> secondaryLocations, String repositoryKey) {
        boolean isSonarSourceRepository = SarifParserCallbackImpl.isSonarSourceRepository(repositoryKey);
        this.logIssue("normal", ruleId, primaryLocation.getAbsolutePath());
        NewIssue newIssue = this.context.newIssue();
        newIssue.forRule(RuleKey.of((String)repositoryKey, (String)ruleId)).at(SarifParserCallbackImpl.createPrimaryLocation(inputFile, primaryLocation, () -> ((NewIssue)newIssue).newLocation(), !isSonarSourceRepository));
        this.populateSecondaryLocations(secondaryLocations, () -> ((NewIssue)newIssue).newLocation(), arg_0 -> ((NewIssue)newIssue).addLocation(arg_0), !isSonarSourceRepository);
        newIssue.save();
    }

    private static NewIssueLocation createPrimaryLocation(InputFile inputFile, Location primaryLocation, Supplier<NewIssueLocation> newIssueLocationSupplier, boolean isLocationResilient) {
        return SarifParserCallbackImpl.createIssueLocation(inputFile, primaryLocation, newIssueLocationSupplier, isLocationResilient);
    }

    private void populateSecondaryLocations(Collection<Location> secondaryLocations, Supplier<NewIssueLocation> newIssueLocationSupplier, Consumer<NewIssueLocation> newIssueLocationConsumer, boolean isLocationResilient) {
        for (Location secondaryLocation : secondaryLocations) {
            InputFile inputFile = this.context.fileSystem().inputFile(this.context.fileSystem().predicates().hasAbsolutePath(secondaryLocation.getAbsolutePath()));
            if (inputFile == null) continue;
            NewIssueLocation newIssueLocation = SarifParserCallbackImpl.createIssueLocation(inputFile, secondaryLocation, newIssueLocationSupplier, isLocationResilient);
            newIssueLocationConsumer.accept(newIssueLocation);
        }
    }

    private static NewIssueLocation createIssueLocation(InputFile inputFile, Location location, Supplier<NewIssueLocation> newIssueLocationSupplier, boolean isLocationResilient) {
        NewIssueLocation newIssueLocation = newIssueLocationSupplier.get().on((InputComponent)inputFile);
        try {
            newIssueLocation = newIssueLocation.at(inputFile.newRange(location.getStartLine(), location.getStartColumn(), location.getEndLine(), location.getEndColumn()));
        }
        catch (IllegalArgumentException ex1) {
            LOG.debug("Precise issue location cannot be found! Location: {}", (Object)location);
            if (!isLocationResilient && !SarifParserCallbackImpl.isLocationInsideRazorFile(location)) {
                throw ex1;
            }
            try {
                newIssueLocation = newIssueLocation.at(inputFile.selectLine(location.getStartLine()));
            }
            catch (IllegalArgumentException ex2) {
                LOG.debug("Line issue location cannot be found! Location: {}", (Object)location);
            }
        }
        String message = location.getMessage();
        if (message != null) {
            newIssueLocation.message(message);
        }
        return newIssueLocation;
    }

    @Override
    public void onRule(String ruleId, @Nullable String shortDescription, @Nullable String fullDescription, String defaultLevel, @Nullable String category) {
        if (this.repositoryKeyByRoslynRuleKey.containsKey(ruleId) || !this.shouldCreateExternalIssue(ruleId)) {
            return;
        }
        this.defaultLevelByRuleId.put(ruleId, defaultLevel);
        RuleType ruleType = this.mapRuleType(category, defaultLevel);
        this.ruleTypeByRuleId.put(ruleId, ruleType);
        this.context.newAdHocRule().engineId(EXTERNAL_ENGINE_ID).ruleId(ruleId).severity(SarifParserCallbackImpl.mapSeverity(defaultLevel)).name(shortDescription != null ? shortDescription : ruleId).description(fullDescription).type(ruleType).save();
    }

    private boolean shouldCreateExternalIssue(String ruleId) {
        return !this.ignoreThirdPartyIssues && !ruleId.matches("^S\\d{3,4}$");
    }

    private RuleType mapRuleType(@Nullable String category, String defaultLevel) {
        if (category != null) {
            if (this.bugCategories.contains(category)) {
                return RuleType.BUG;
            }
            if (this.codeSmellCategories.contains(category)) {
                return RuleType.CODE_SMELL;
            }
            if (this.vulnerabilityCategories.contains(category)) {
                return RuleType.VULNERABILITY;
            }
        }
        return "Error".equalsIgnoreCase(defaultLevel) ? RuleType.BUG : RuleType.CODE_SMELL;
    }

    private static Severity mapSeverity(String defaultLevel) {
        switch (defaultLevel.toLowerCase(Locale.ENGLISH)) {
            case "error": {
                return Severity.CRITICAL;
            }
            case "warning": {
                return Severity.MAJOR;
            }
        }
        return Severity.INFO;
    }

    private static boolean isSonarSourceRepository(String repositoryKey) {
        return OWN_REPOSITORIES.contains(repositoryKey);
    }

    private static boolean isLocationInsideRazorFile(Location location) {
        String absolutePath = location.getAbsolutePath();
        return absolutePath.endsWith(".razor") || absolutePath.endsWith(".cshtml");
    }

    private void logIssue(String issueType, String ruleId, String location) {
        LOG.debug("Adding {} issue {}: {}", new Object[]{issueType, ruleId, location});
    }

    private void logMissingInputFile(String ruleId, String filePath) {
        LOG.debug("Skipping issue {}, input file not found or excluded: {}", (Object)ruleId, (Object)filePath);
    }

    private static class Issue {
        private String ruleId;
        private String moduleId;
        private String absolutePath;
        private int startLine;
        private int startColumn;
        private int endLine;
        private int endColumn;

        Issue(String ruleId, String moduleOrPath, boolean isModuleId) {
            this.ruleId = ruleId;
            if (isModuleId) {
                this.moduleId = moduleOrPath;
                this.absolutePath = "";
            } else {
                this.absolutePath = moduleOrPath;
            }
        }

        Issue(String ruleId, Location location) {
            this.ruleId = ruleId;
            this.absolutePath = location.getAbsolutePath();
            this.startLine = location.getStartLine();
            this.startColumn = location.getStartColumn();
            this.endLine = location.getEndLine();
            this.endColumn = location.getEndColumn();
        }

        public int hashCode() {
            return Objects.hash(this.ruleId, this.moduleId, this.absolutePath, this.startLine, this.startColumn, this.endLine, this.endColumn);
        }

        public boolean equals(Object other) {
            if (!(other instanceof Issue)) {
                return false;
            }
            Issue o = (Issue)other;
            return Objects.equals(this.ruleId, o.ruleId) && Objects.equals(this.moduleId, o.moduleId) && Objects.equals(this.startLine, o.startLine) && Objects.equals(this.startColumn, o.startColumn) && Objects.equals(this.endLine, o.endLine) && Objects.equals(this.endColumn, o.endColumn) && Paths.get(this.absolutePath, new String[0]).equals(Paths.get(o.absolutePath, new String[0]));
        }
    }
}

