/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.dotnet.shared.plugins.protobuf;

import java.util.function.UnaryOperator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonar.api.batch.fs.InputFile;
import org.sonar.api.batch.sensor.SensorContext;
import org.sonar.api.batch.sensor.cpd.NewCpdTokens;
import org.sonarsource.dotnet.protobuf.SonarAnalyzer;
import org.sonarsource.dotnet.shared.plugins.SensorContextUtils;
import org.sonarsource.dotnet.shared.plugins.protobuf.ProtobufImporter;

public class CPDTokensImporter
extends ProtobufImporter<SonarAnalyzer.CopyPasteTokenInfo> {
    private static final Logger LOG = LoggerFactory.getLogger(CPDTokensImporter.class);
    private final SensorContext context;

    public CPDTokensImporter(SensorContext context, UnaryOperator<String> toRealPath) {
        super(SonarAnalyzer.CopyPasteTokenInfo.parser(), context, SonarAnalyzer.CopyPasteTokenInfo::getFilePath, toRealPath);
        this.context = context;
    }

    @Override
    void consumeFor(InputFile inputFile, SonarAnalyzer.CopyPasteTokenInfo message) {
        NewCpdTokens cpdTokens = this.context.newCpdTokens().onFile(inputFile);
        for (SonarAnalyzer.CopyPasteTokenInfo.TokenInfo tokenInfo : message.getTokenInfoList()) {
            SensorContextUtils.toTextRange(inputFile, tokenInfo.getTextRange()).ifPresentOrElse(textRange -> cpdTokens.addToken(textRange, tokenInfo.getTokenValue()), () -> LOG.debug("The reported token was out of the range. File {}, Range {}", (Object)inputFile.filename(), (Object)tokenInfo.getTextRange()));
        }
        cpdTokens.save();
    }
}

