/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.dotnet.shared.plugins.protobuf;

import java.io.Serializable;
import java.util.HashSet;
import java.util.function.UnaryOperator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonar.api.batch.fs.InputComponent;
import org.sonar.api.batch.fs.InputFile;
import org.sonar.api.batch.measure.Metric;
import org.sonar.api.batch.sensor.SensorContext;
import org.sonar.api.issue.NoSonarFilter;
import org.sonar.api.measures.CoreMetrics;
import org.sonar.api.measures.FileLinesContext;
import org.sonar.api.measures.FileLinesContextFactory;
import org.sonarsource.dotnet.protobuf.SonarAnalyzer;
import org.sonarsource.dotnet.shared.plugins.protobuf.ProtobufImporter;

public class MetricsImporter
extends ProtobufImporter<SonarAnalyzer.MetricsInfo> {
    private final SensorContext context;
    private final FileLinesContextFactory fileLinesContextFactory;
    private final NoSonarFilter noSonarFilter;
    private static final Logger LOG = LoggerFactory.getLogger(MetricsImporter.class);

    public MetricsImporter(SensorContext context, FileLinesContextFactory fileLinesContextFactory, NoSonarFilter noSonarFilter, UnaryOperator<String> toRealPath) {
        super(SonarAnalyzer.MetricsInfo.parser(), context, SonarAnalyzer.MetricsInfo::getFilePath, toRealPath);
        this.context = context;
        this.fileLinesContextFactory = fileLinesContextFactory;
        this.noSonarFilter = noSonarFilter;
    }

    @Override
    void consumeFor(InputFile inputFile, SonarAnalyzer.MetricsInfo message) {
        MetricsImporter.saveMetric(this.context, inputFile, CoreMetrics.CLASSES, message.getClassCount());
        MetricsImporter.saveMetric(this.context, inputFile, CoreMetrics.STATEMENTS, message.getStatementCount());
        MetricsImporter.saveMetric(this.context, inputFile, CoreMetrics.FUNCTIONS, message.getFunctionCount());
        MetricsImporter.saveMetric(this.context, inputFile, CoreMetrics.COMPLEXITY, message.getComplexity());
        this.noSonarFilter.noSonarInFile(inputFile, new HashSet<Integer>(message.getNoSonarCommentList()));
        FileLinesContext fileLinesContext = this.fileLinesContextFactory.createFor(inputFile);
        MetricsImporter.saveMetric(this.context, inputFile, CoreMetrics.COMMENT_LINES, message.getNonBlankCommentCount());
        int lineCount = inputFile.lines();
        for (int line : message.getCodeLineList()) {
            if (line <= lineCount) {
                fileLinesContext.setIntValue("ncloc_data", line, 1);
                continue;
            }
            if (!LOG.isDebugEnabled()) continue;
            LOG.debug("The code line number was out of the range. File {}, Line {}", (Object)inputFile.filename(), (Object)line);
        }
        MetricsImporter.saveMetric(this.context, inputFile, CoreMetrics.NCLOC, message.getCodeLineCount());
        if (message.getCognitiveComplexity() >= 0) {
            MetricsImporter.saveMetric(this.context, inputFile, CoreMetrics.COGNITIVE_COMPLEXITY, message.getCognitiveComplexity());
        }
        for (Integer executableLineNumber : message.getExecutableLinesList()) {
            fileLinesContext.setIntValue("executable_lines_data", executableLineNumber.intValue(), 1);
        }
        fileLinesContext.save();
    }

    private static <T extends Serializable> void saveMetric(SensorContext context, InputFile inputFile, Metric<T> metric, T value) {
        context.newMeasure().on((InputComponent)inputFile).forMetric(metric).withValue(value).save();
    }
}

