/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.dotnet.tests;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Splitter;
import java.io.File;
import org.sonar.api.batch.BatchSide;
import org.sonar.api.config.Settings;
import org.sonar.plugins.dotnet.tests.NUnitTestResultsFileParser;
import org.sonar.plugins.dotnet.tests.UnitTestConfiguration;
import org.sonar.plugins.dotnet.tests.UnitTestResults;
import org.sonar.plugins.dotnet.tests.UnitTestResultsParser;
import org.sonar.plugins.dotnet.tests.VisualStudioTestResultsFileParser;
import org.sonar.plugins.dotnet.tests.WildcardPatternFileProvider;
import org.sonar.plugins.dotnet.tests.XUnitTestResultsFileParser;

@BatchSide
public class UnitTestResultsAggregator {
    private final UnitTestConfiguration unitTestConf;
    private final Settings settings;
    private final VisualStudioTestResultsFileParser visualStudioTestResultsFileParser;
    private final NUnitTestResultsFileParser nunitTestResultsFileParser;
    private final XUnitTestResultsFileParser xunitTestResultsFileParser;

    public UnitTestResultsAggregator(UnitTestConfiguration unitTestConf, Settings settings) {
        this(unitTestConf, settings, new VisualStudioTestResultsFileParser(), new NUnitTestResultsFileParser(), new XUnitTestResultsFileParser());
    }

    @VisibleForTesting
    public UnitTestResultsAggregator(UnitTestConfiguration unitTestConf, Settings settings, VisualStudioTestResultsFileParser visualStudioTestResultsFileParser, NUnitTestResultsFileParser nunitTestResultsFileParser, XUnitTestResultsFileParser xunitTestResultsFileParser) {
        this.unitTestConf = unitTestConf;
        this.settings = settings;
        this.visualStudioTestResultsFileParser = visualStudioTestResultsFileParser;
        this.nunitTestResultsFileParser = nunitTestResultsFileParser;
        this.xunitTestResultsFileParser = xunitTestResultsFileParser;
    }

    public boolean hasUnitTestResultsProperty() {
        return this.hasVisualStudioTestResultsFile() || this.hasNUnitTestResultsFile() || this.hasXUnitTestResultsFile();
    }

    private boolean hasVisualStudioTestResultsFile() {
        return this.settings.hasKey(this.unitTestConf.visualStudioTestResultsFilePropertyKey());
    }

    private boolean hasNUnitTestResultsFile() {
        return this.settings.hasKey(this.unitTestConf.nunitTestResultsFilePropertyKey());
    }

    private boolean hasXUnitTestResultsFile() {
        return this.settings.hasKey(this.unitTestConf.xunitTestResultsFilePropertyKey());
    }

    public UnitTestResults aggregate(WildcardPatternFileProvider wildcardPatternFileProvider, UnitTestResults unitTestResults) {
        if (this.hasVisualStudioTestResultsFile()) {
            UnitTestResultsAggregator.aggregate(wildcardPatternFileProvider, this.settings.getString(this.unitTestConf.visualStudioTestResultsFilePropertyKey()), this.visualStudioTestResultsFileParser, unitTestResults);
        }
        if (this.hasNUnitTestResultsFile()) {
            UnitTestResultsAggregator.aggregate(wildcardPatternFileProvider, this.settings.getString(this.unitTestConf.nunitTestResultsFilePropertyKey()), this.nunitTestResultsFileParser, unitTestResults);
        }
        if (this.hasXUnitTestResultsFile()) {
            UnitTestResultsAggregator.aggregate(wildcardPatternFileProvider, this.settings.getString(this.unitTestConf.xunitTestResultsFilePropertyKey()), this.xunitTestResultsFileParser, unitTestResults);
        }
        return unitTestResults;
    }

    private static void aggregate(WildcardPatternFileProvider wildcardPatternFileProvider, String reportPaths, UnitTestResultsParser parser, UnitTestResults unitTestResults) {
        for (String reportPathPattern : Splitter.on((char)',').trimResults().omitEmptyStrings().split((CharSequence)reportPaths)) {
            for (File reportFile : wildcardPatternFileProvider.listFiles(reportPathPattern)) {
                parser.accept(reportFile, unitTestResults);
            }
        }
    }
}

