/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.dotnet.tests;

import java.io.File;
import java.io.IOException;
import org.sonar.api.utils.log.Logger;
import org.sonar.api.utils.log.Loggers;
import org.sonar.plugins.dotnet.tests.UnitTestResults;
import org.sonar.plugins.dotnet.tests.UnitTestResultsParser;
import org.sonar.plugins.dotnet.tests.XmlParserHelper;

public class XUnitTestResultsFileParser
implements UnitTestResultsParser {
    private static final Logger LOG = Loggers.get(XUnitTestResultsFileParser.class);

    @Override
    public void accept(File file, UnitTestResults unitTestResults) {
        LOG.info("Parsing the XUnit Test Results file " + file.getAbsolutePath());
        new Parser(file, unitTestResults).parse();
    }

    private static class Parser {
        private final File file;
        private final UnitTestResults unitTestResults;

        public Parser(File file, UnitTestResults unitTestResults) {
            this.file = file;
            this.unitTestResults = unitTestResults;
        }

        public void parse() {
            try (XmlParserHelper xmlParserHelper = new XmlParserHelper(this.file);){
                String tag = xmlParserHelper.nextStartTag();
                if (!"assemblies".equals(tag) && !"assembly".equals(tag)) {
                    throw xmlParserHelper.parseError("Expected either an <assemblies> or an <assembly> root tag, but got <" + tag + "> instead.");
                }
                do {
                    if (!"assembly".equals(tag)) continue;
                    this.handleAssemblyTag(xmlParserHelper);
                } while ((tag = xmlParserHelper.nextStartTag()) != null);
            }
            catch (IOException e) {
                throw new IllegalStateException("Unable to close report", e);
            }
        }

        private void handleAssemblyTag(XmlParserHelper xmlParserHelper) {
            int total = xmlParserHelper.getRequiredIntAttribute("total");
            int passed = xmlParserHelper.getRequiredIntAttribute("passed");
            int failed = xmlParserHelper.getRequiredIntAttribute("failed");
            int skipped = xmlParserHelper.getRequiredIntAttribute("skipped");
            int errors = xmlParserHelper.getIntAttributeOrZero("errors");
            Double executionTime = xmlParserHelper.getDoubleAttribute("time");
            if (executionTime != null) {
                executionTime = executionTime * 1000.0;
            }
            this.unitTestResults.add(total, passed, skipped, failed, errors, executionTime != null ? Long.valueOf((long)executionTime.doubleValue()) : null);
        }
    }
}

