/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.dotnet.tests;

import java.io.File;
import java.io.Serializable;
import org.sonar.api.batch.bootstrap.ProjectDefinition;
import org.sonar.api.batch.fs.InputComponent;
import org.sonar.api.batch.measure.Metric;
import org.sonar.api.batch.sensor.Sensor;
import org.sonar.api.batch.sensor.SensorContext;
import org.sonar.api.batch.sensor.SensorDescriptor;
import org.sonar.api.config.Configuration;
import org.sonar.api.measures.CoreMetrics;
import org.sonar.api.utils.log.Logger;
import org.sonar.api.utils.log.Loggers;
import org.sonar.plugins.dotnet.tests.CoverageReportImportSensor;
import org.sonar.plugins.dotnet.tests.UnitTestResults;
import org.sonar.plugins.dotnet.tests.UnitTestResultsAggregator;
import org.sonar.plugins.dotnet.tests.WildcardPatternFileProvider;

public class UnitTestResultsImportSensor
implements Sensor {
    private static final Logger LOG = Loggers.get(CoverageReportImportSensor.class);
    private final WildcardPatternFileProvider wildcardPatternFileProvider = new WildcardPatternFileProvider(new File("."), File.separator);
    private final UnitTestResultsAggregator unitTestResultsAggregator;
    private final ProjectDefinition projectDef;
    private final String languageKey;
    private final String languageName;

    public UnitTestResultsImportSensor(UnitTestResultsAggregator unitTestResultsAggregator, ProjectDefinition projectDef, String languageKey, String languageName) {
        this.unitTestResultsAggregator = unitTestResultsAggregator;
        this.projectDef = projectDef;
        this.languageKey = languageKey;
        this.languageName = languageName;
    }

    public void describe(SensorDescriptor descriptor) {
        String name = String.format("%s Unit Test Results Import", this.languageName);
        descriptor.name(name);
        descriptor.global();
        descriptor.onlyOnLanguage(this.languageKey);
        descriptor.onlyWhenConfiguration(c -> this.unitTestResultsAggregator.hasUnitTestResultsProperty(arg_0 -> ((Configuration)c).hasKey(arg_0)));
    }

    public void execute(SensorContext context) {
        if (!this.unitTestResultsAggregator.hasUnitTestResultsProperty()) {
            LOG.debug("No unit test results property. Skip Sensor");
            return;
        }
        if (this.projectDef.getParent() == null) {
            this.analyze(context, new UnitTestResults());
        }
    }

    void analyze(SensorContext context, UnitTestResults unitTestResults) {
        UnitTestResults aggregatedResults = this.unitTestResultsAggregator.aggregate(this.wildcardPatternFileProvider, unitTestResults);
        context.newMeasure().forMetric((Metric)CoreMetrics.TESTS).on((InputComponent)context.module()).withValue((Serializable)Integer.valueOf(aggregatedResults.tests())).save();
        context.newMeasure().forMetric((Metric)CoreMetrics.TEST_ERRORS).on((InputComponent)context.module()).withValue((Serializable)Integer.valueOf(aggregatedResults.errors())).save();
        context.newMeasure().forMetric((Metric)CoreMetrics.TEST_FAILURES).on((InputComponent)context.module()).withValue((Serializable)Integer.valueOf(aggregatedResults.failures())).save();
        context.newMeasure().forMetric((Metric)CoreMetrics.SKIPPED_TESTS).on((InputComponent)context.module()).withValue((Serializable)Integer.valueOf(aggregatedResults.skipped())).save();
        Long executionTime = aggregatedResults.executionTime();
        if (executionTime != null) {
            context.newMeasure().forMetric((Metric)CoreMetrics.TEST_EXECUTION_TIME).on((InputComponent)context.module()).withValue((Serializable)executionTime).save();
        }
        if (aggregatedResults.tests() > 0) {
            context.newMeasure().forMetric((Metric)CoreMetrics.TEST_SUCCESS_DENSITY).on((InputComponent)context.module()).withValue((Serializable)Double.valueOf(aggregatedResults.passedPercentage())).save();
        }
    }
}

