/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.dotnet.tests;

import java.io.File;
import java.io.IOException;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.sonar.api.utils.log.Logger;
import org.sonar.api.utils.log.Loggers;
import org.sonar.plugins.dotnet.tests.UnitTestResults;
import org.sonar.plugins.dotnet.tests.UnitTestResultsParser;
import org.sonar.plugins.dotnet.tests.XmlParserHelper;

public class VisualStudioTestResultsFileParser
implements UnitTestResultsParser {
    private static final Logger LOG = Loggers.get(VisualStudioTestResultsFileParser.class);

    @Override
    public void accept(File file, UnitTestResults unitTestResults) {
        LOG.info("Parsing the Visual Studio Test Results file " + file.getAbsolutePath());
        new Parser(file, unitTestResults).parse();
    }

    private static class Parser {
        private final File file;
        private final UnitTestResults unitTestResults;
        private DateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSXXX");
        private Pattern millisecondsPattern = Pattern.compile("(\\.([0-9]{0,3}))[0-9]*+");
        private boolean foundCounters;

        Parser(File file, UnitTestResults unitTestResults) {
            this.file = file;
            this.unitTestResults = unitTestResults;
        }

        public void parse() {
            try (XmlParserHelper xmlParserHelper = new XmlParserHelper(this.file);){
                Parser.checkRootTag(xmlParserHelper);
                this.dispatchTags(xmlParserHelper);
                if (!this.foundCounters) {
                    throw new IllegalArgumentException("The mandatory <Counters> tag is missing in " + this.file.getAbsolutePath());
                }
            }
            catch (IOException e) {
                throw new IllegalStateException("Unable to close report", e);
            }
        }

        private void dispatchTags(XmlParserHelper xmlParserHelper) {
            String tagName;
            while ((tagName = xmlParserHelper.nextStartTag()) != null) {
                if ("Counters".equals(tagName)) {
                    this.handleCountersTag(xmlParserHelper);
                    continue;
                }
                if (!"Times".equals(tagName)) continue;
                this.handleTimesTag(xmlParserHelper);
            }
        }

        private void handleCountersTag(XmlParserHelper xmlParserHelper) {
            this.foundCounters = true;
            int total = xmlParserHelper.getIntAttributeOrZero("total");
            int passed = xmlParserHelper.getIntAttributeOrZero("passed");
            int failed = xmlParserHelper.getIntAttributeOrZero("failed");
            int errors = xmlParserHelper.getIntAttributeOrZero("error");
            int timeout = xmlParserHelper.getIntAttributeOrZero("timeout");
            int aborted = xmlParserHelper.getIntAttributeOrZero("aborted");
            int executed = xmlParserHelper.getIntAttributeOrZero("executed");
            int skipped = total - executed;
            int failures = timeout + failed + aborted;
            this.unitTestResults.add(total, passed, skipped, failures, errors, null);
        }

        private void handleTimesTag(XmlParserHelper xmlParserHelper) {
            Date start = this.getRequiredDateAttribute(xmlParserHelper, "start");
            Date finish = this.getRequiredDateAttribute(xmlParserHelper, "finish");
            long duration = finish.getTime() - start.getTime();
            this.unitTestResults.add(0, 0, 0, 0, 0, duration);
        }

        private Date getRequiredDateAttribute(XmlParserHelper xmlParserHelper, String name) {
            String value = xmlParserHelper.getRequiredAttribute(name);
            try {
                value = this.keepOnlyMilliseconds(value);
                return this.dateFormat.parse(value);
            }
            catch (ParseException e) {
                throw xmlParserHelper.parseError("Expected an valid date and time instead of \"" + value + "\" for the attribute \"" + name + "\". " + e.getMessage());
            }
        }

        private String keepOnlyMilliseconds(String value) {
            StringBuffer sb = new StringBuffer();
            Matcher matcher = this.millisecondsPattern.matcher(value);
            StringBuilder trailingZeros = new StringBuilder();
            while (matcher.find()) {
                String milliseconds = matcher.group(2);
                trailingZeros.setLength(0);
                for (int i = 0; i < 3 - milliseconds.length(); ++i) {
                    trailingZeros.append("0");
                }
                matcher.appendReplacement(sb, "$1" + trailingZeros);
            }
            matcher.appendTail(sb);
            return sb.toString();
        }

        private static void checkRootTag(XmlParserHelper xmlParserHelper) {
            xmlParserHelper.checkRootTag("TestRun");
        }
    }
}

