/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.dotnet.tests;

import java.io.File;
import java.util.Map;
import org.sonar.api.batch.fs.FilePredicates;
import org.sonar.api.batch.fs.InputFile;
import org.sonar.api.batch.sensor.Sensor;
import org.sonar.api.batch.sensor.SensorContext;
import org.sonar.api.batch.sensor.SensorDescriptor;
import org.sonar.api.batch.sensor.coverage.NewCoverage;
import org.sonar.api.config.Configuration;
import org.sonar.api.utils.log.Logger;
import org.sonar.api.utils.log.Loggers;
import org.sonar.plugins.dotnet.tests.Coverage;
import org.sonar.plugins.dotnet.tests.CoverageAggregator;
import org.sonar.plugins.dotnet.tests.CoverageConfiguration;
import org.sonar.plugins.dotnet.tests.WildcardPatternFileProvider;

public class CoverageReportImportSensor
implements Sensor {
    private static final Logger LOG = Loggers.get(CoverageReportImportSensor.class);
    private final WildcardPatternFileProvider wildcardPatternFileProvider = new WildcardPatternFileProvider(new File("."), File.separator);
    private final CoverageConfiguration coverageConf;
    private final CoverageAggregator coverageAggregator;
    private final boolean isIntegrationTest;
    private final String languageKey;
    private final String languageName;

    public CoverageReportImportSensor(CoverageConfiguration coverageConf, CoverageAggregator coverageAggregator, String languageKey, String languageName, boolean isIntegrationTest) {
        this.coverageConf = coverageConf;
        this.coverageAggregator = coverageAggregator;
        this.isIntegrationTest = isIntegrationTest;
        this.languageKey = languageKey;
        this.languageName = languageName;
    }

    public void describe(SensorDescriptor descriptor) {
        if (this.isIntegrationTest) {
            descriptor.name("[Deprecated] " + this.languageName + " Integration Tests Coverage Report Import");
        } else {
            descriptor.name(this.languageName + " Tests Coverage Report Import");
        }
        descriptor.global();
        descriptor.onlyWhenConfiguration(c -> this.coverageAggregator.hasCoverageProperty(arg_0 -> ((Configuration)c).hasKey(arg_0)));
        descriptor.onlyOnLanguage(this.languageKey);
    }

    public void execute(SensorContext context) {
        if (!this.coverageAggregator.hasCoverageProperty()) {
            LOG.debug("No coverage property. Skip Sensor");
            return;
        }
        if (this.isIntegrationTest) {
            LOG.warn("Starting with SonarQube 6.2 separation between Unit Tests and Integration Tests Coverage reports is deprecated. Please move all reports specified from *.it.reportPaths into *.reportPaths.");
        }
        this.analyze(context, new Coverage());
    }

    void analyze(SensorContext context, Coverage coverage) {
        this.coverageAggregator.aggregate(this.wildcardPatternFileProvider, coverage);
        boolean hasAnyMainFileCovered = false;
        for (String filePath : coverage.files()) {
            FilePredicates p = context.fileSystem().predicates();
            InputFile inputFile = context.fileSystem().inputFile(p.hasAbsolutePath(filePath));
            if (inputFile == null) {
                LOG.debug("The file '{}' is either excluded or outside of your solution folder therefore Code Coverage will not be imported.", (Object)filePath);
                continue;
            }
            if (inputFile.type().equals((Object)InputFile.Type.TEST) || !this.coverageConf.languageKey().equals(inputFile.language())) continue;
            hasAnyMainFileCovered = true;
            NewCoverage newCoverage = context.newCoverage().onFile(inputFile);
            for (Map.Entry<Integer, Integer> entry : coverage.hits(filePath).entrySet()) {
                newCoverage.lineHits(entry.getKey().intValue(), entry.getValue().intValue());
            }
            newCoverage.save();
        }
        if (!coverage.files().isEmpty() && !hasAnyMainFileCovered) {
            LOG.warn("The Code Coverage report doesn't contain any coverage data for the included files. For troubleshooting hints, please refer to https://docs.sonarqube.org/x/CoBh");
        }
    }
}

