/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.dotnet.shared.plugins;

import java.io.IOException;
import java.io.Writer;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;
import org.sonar.api.profiles.ProfileExporter;
import org.sonar.api.profiles.RulesProfile;
import org.sonar.api.rules.ActiveRule;
import org.sonar.api.rules.Rule;
import org.sonar.api.rules.RuleFinder;
import org.sonar.api.rules.RuleQuery;

public abstract class AbstractSonarLintProfileExporter
extends ProfileExporter {
    private final String analyzerName;
    private final String repositoryKey;
    private final RuleFinder ruleFinder;

    public AbstractSonarLintProfileExporter(String profileKey, String profileName, String languageKey, String analyzerName, String repositoryKey, RuleFinder ruleFinder) {
        super(profileKey, profileName);
        this.ruleFinder = ruleFinder;
        this.setSupportedLanguages(new String[]{languageKey});
        this.analyzerName = analyzerName;
        this.repositoryKey = repositoryKey;
    }

    public void exportProfile(RulesProfile ruleProfile, Writer writer) {
        Set allRuleKeys = this.ruleFinder.findAll(RuleQuery.create().withRepositoryKey(this.repositoryKey)).stream().map(Rule::getKey).collect(Collectors.toSet());
        HashSet disabledRuleKeys = new HashSet(allRuleKeys);
        AbstractSonarLintProfileExporter.appendLine(writer, "<?xml version=\"1.0\" encoding=\"utf-8\"?>");
        AbstractSonarLintProfileExporter.appendLine(writer, "<RuleSet Name=\"Rules for SonarLint\" Description=\"This rule set was automatically generated from SonarQube.\" ToolsVersion=\"14.0\">");
        AbstractSonarLintProfileExporter.appendLine(writer, "  <Rules AnalyzerId=\"" + this.analyzerName + "\" RuleNamespace=\"" + this.analyzerName + "\">");
        for (ActiveRule activeRule : ruleProfile.getActiveRulesByRepository(this.repositoryKey)) {
            Rule rule = activeRule.getRule();
            disabledRuleKeys.remove(rule.getKey());
            AbstractSonarLintProfileExporter.appendLine(writer, "    <Rule Id=\"" + rule.getKey() + "\" Action=\"Warning\" />");
        }
        for (String disableRuleKey : disabledRuleKeys) {
            AbstractSonarLintProfileExporter.appendLine(writer, "    <Rule Id=\"" + disableRuleKey + "\" Action=\"None\" />");
        }
        AbstractSonarLintProfileExporter.appendLine(writer, "  </Rules>");
        AbstractSonarLintProfileExporter.appendLine(writer, "</RuleSet>");
    }

    private static void appendLine(Writer writer, String line) {
        try {
            writer.write(line);
            writer.write("\r\n");
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }
}

