/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.dotnet.shared.plugins;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.List;
import java.util.Locale;
import java.util.function.UnaryOperator;
import java.util.stream.Stream;
import org.sonar.api.batch.sensor.SensorContext;
import org.sonar.api.issue.NoSonarFilter;
import org.sonar.api.measures.FileLinesContextFactory;
import org.sonar.api.scanner.ScannerSide;
import org.sonar.api.utils.log.Logger;
import org.sonar.api.utils.log.Loggers;
import org.sonarsource.dotnet.protobuf.SonarAnalyzer;
import org.sonarsource.dotnet.shared.StringUtils;
import org.sonarsource.dotnet.shared.plugins.protobuf.ProtobufImporters;
import org.sonarsource.dotnet.shared.plugins.protobuf.RawProtobufImporter;

@ScannerSide
public class ProtobufDataImporter {
    private static final Logger LOG = Loggers.get(ProtobufDataImporter.class);
    private final FileLinesContextFactory fileLinesContextFactory;
    private final NoSonarFilter noSonarFilter;

    public ProtobufDataImporter(FileLinesContextFactory fileLinesContextFactory, NoSonarFilter noSonarFilter) {
        this.fileLinesContextFactory = fileLinesContextFactory;
        this.noSonarFilter = noSonarFilter;
    }

    public void importResults(SensorContext context, List<Path> protobufReportsDirectories, UnaryOperator<String> toRealPath) {
        RawProtobufImporter<SonarAnalyzer.MetricsInfo> metricsImporter = ProtobufImporters.metricsImporter(context, this.fileLinesContextFactory, this.noSonarFilter, toRealPath);
        RawProtobufImporter<SonarAnalyzer.TokenTypeInfo> highlightImporter = ProtobufImporters.highlightImporter(context, toRealPath);
        RawProtobufImporter<SonarAnalyzer.SymbolReferenceInfo> symbolRefsImporter = ProtobufImporters.symbolRefsImporter(context, toRealPath);
        RawProtobufImporter<SonarAnalyzer.CopyPasteTokenInfo> cpdTokensImporter = ProtobufImporters.cpdTokensImporter(context, toRealPath);
        for (Path protobufReportsDir : protobufReportsDirectories) {
            long protoFiles = ProtobufDataImporter.countProtoFiles(protobufReportsDir);
            LOG.info(String.format("Importing results from %d proto %s in '%s'", protoFiles, StringUtils.pluralize("file", protoFiles), protobufReportsDir));
            ProtobufDataImporter.parseProtobuf(metricsImporter, protobufReportsDir, "metrics.pb");
            ProtobufDataImporter.parseProtobuf(highlightImporter, protobufReportsDir, "token-type.pb");
            ProtobufDataImporter.parseProtobuf(symbolRefsImporter, protobufReportsDir, "symrefs.pb");
            ProtobufDataImporter.parseProtobuf(cpdTokensImporter, protobufReportsDir, "token-cpd.pb");
        }
        metricsImporter.save();
        highlightImporter.save();
        symbolRefsImporter.save();
        cpdTokensImporter.save();
    }

    private static long countProtoFiles(Path dir) {
        long l;
        block8: {
            Stream<Path> stream = Files.list(dir);
            try {
                l = stream.filter(p -> p.getFileName().toString().toLowerCase(Locale.ENGLISH).endsWith(".pb")).count();
                if (stream == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (stream != null) {
                        try {
                            stream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new IllegalStateException("unexpected error while reading files in: " + dir, e);
                }
            }
            stream.close();
        }
        return l;
    }

    private static void parseProtobuf(RawProtobufImporter<?> importer, Path workDirectory, String filename) {
        Path protobuf = workDirectory.resolve(filename);
        if (protobuf.toFile().exists()) {
            importer.accept(protobuf);
        } else {
            LOG.warn("Protobuf file not found: " + protobuf);
        }
    }
}

