/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.dotnet.shared.plugins;

import java.io.IOException;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.Map;
import java.util.function.UnaryOperator;
import org.sonar.api.utils.log.Logger;
import org.sonar.api.utils.log.Loggers;

public class RealPathProvider
implements UnaryOperator<String> {
    private static final Logger LOG = Loggers.get(RealPathProvider.class);
    private final Map<String, String> cachedPaths = new HashMap<String, String>();

    @Override
    public String apply(String path) {
        return this.cachedPaths.computeIfAbsent(path, this::getRealPath);
    }

    public String getRealPath(String path) {
        try {
            return Paths.get(path, new String[0]).toRealPath(new LinkOption[0]).toString();
        }
        catch (IOException e) {
            LOG.debug("Failed to retrieve the real full path for '{}'", (Object)path);
            return path;
        }
    }
}

