/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.dotnet.shared.plugins;

import javax.annotation.CheckForNull;
import org.sonar.api.batch.fs.FilePredicates;
import org.sonar.api.batch.fs.FileSystem;
import org.sonar.api.batch.fs.InputFile;
import org.sonar.api.batch.fs.TextRange;
import org.sonarsource.dotnet.protobuf.SonarAnalyzer;

public final class SensorContextUtils {
    private SensorContextUtils() {
    }

    @CheckForNull
    public static InputFile toInputFile(FileSystem fs, String file) {
        return fs.inputFile(fs.predicates().hasPath(file));
    }

    public static boolean hasFilesOfType(FileSystem fs, InputFile.Type fileType, String languageKey) {
        FilePredicates p = fs.predicates();
        return fs.inputFiles(p.and(p.hasType(fileType), p.hasLanguage(languageKey))).iterator().hasNext();
    }

    public static boolean hasFilesOfLanguage(FileSystem fs, String languageKey) {
        FilePredicates p = fs.predicates();
        return fs.inputFiles(p.hasLanguage(languageKey)).iterator().hasNext();
    }

    public static boolean hasAnyMainFiles(FileSystem fs) {
        return fs.inputFiles(fs.predicates().hasType(InputFile.Type.MAIN)).iterator().hasNext();
    }

    public static TextRange toTextRange(InputFile inputFile, SonarAnalyzer.TextRange pbTextRange) {
        int startLine = pbTextRange.getStartLine();
        int startLineOffset = pbTextRange.getStartOffset();
        int endLine = pbTextRange.getEndLine();
        int endLineOffset = pbTextRange.getEndOffset();
        return inputFile.newRange(startLine, startLineOffset, endLine, endLineOffset);
    }
}

