/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.dotnet.tests;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.sonar.plugins.dotnet.tests.BranchCoverage;
import org.sonar.plugins.dotnet.tests.BranchPoint;

public class Coverage {
    private static final int MINIMUM_FILE_LINES = 100;
    private static final int GROW_FACTOR = 2;
    private static final int SPECIAL_HITS_NON_EXECUTABLE = -1;
    private final Map<String, int[]> hitsByLineAndFile = new HashMap<String, int[]>();
    private final List<BranchPoint> branchPoints = new ArrayList<BranchPoint>();

    void addHits(String file, int line, int hits) {
        int i;
        int[] oldHitsByLine = this.hitsByLineAndFile.get(file);
        if (oldHitsByLine == null) {
            oldHitsByLine = new int[Math.max(line, 100)];
            for (i = 0; i < oldHitsByLine.length; ++i) {
                oldHitsByLine[i] = -1;
            }
            this.hitsByLineAndFile.put(file, oldHitsByLine);
        } else if (oldHitsByLine.length < line) {
            int[] tmp = new int[line * 2];
            System.arraycopy(oldHitsByLine, 0, tmp, 0, oldHitsByLine.length);
            for (int i2 = oldHitsByLine.length; i2 < tmp.length; ++i2) {
                tmp[i2] = -1;
            }
            oldHitsByLine = tmp;
            this.hitsByLineAndFile.put(file, oldHitsByLine);
        }
        i = line - 1;
        if (oldHitsByLine[i] == -1) {
            oldHitsByLine[i] = 0;
        }
        int n = i;
        oldHitsByLine[n] = oldHitsByLine[n] + hits;
    }

    public void add(BranchPoint branchPoint) {
        this.branchPoints.add(branchPoint);
    }

    public Set<String> files() {
        return this.hitsByLineAndFile.keySet();
    }

    Map<Integer, Integer> hits(String file) {
        int[] oldHitsByLine = this.hitsByLineAndFile.get(file);
        if (oldHitsByLine == null) {
            return Collections.emptyMap();
        }
        HashMap<Integer, Integer> result = new HashMap<Integer, Integer>();
        for (int i = 0; i < oldHitsByLine.length; ++i) {
            if (oldHitsByLine[i] == -1) continue;
            result.put(i + 1, oldHitsByLine[i]);
        }
        return result;
    }

    List<BranchCoverage> getBranchCoverage(String file) {
        return this.branchPoints.stream().filter(point -> point.getFilePath().equals(file)).collect(Collectors.groupingBy(BranchPoint::getStartLine)).entrySet().stream().map(x -> Coverage.getBranchCoverage((Integer)x.getKey(), (List)x.getValue())).filter(x -> x.getConditions() > 1).toList();
    }

    void mergeWith(Coverage otherCoverage) {
        this.mergeLineHits(otherCoverage);
        this.branchPoints.addAll(otherCoverage.branchPoints);
    }

    private void mergeLineHits(Coverage otherCoverage) {
        Map<String, int[]> other = otherCoverage.hitsByLineAndFile;
        for (Map.Entry<String, int[]> entry : other.entrySet()) {
            String file = entry.getKey();
            int[] otherHitsByLine = entry.getValue();
            for (int i = otherHitsByLine.length - 1; i >= 0; --i) {
                this.addHits(file, i + 1, otherHitsByLine[i]);
            }
        }
    }

    private static BranchCoverage getBranchCoverage(int lineNumber, List<BranchPoint> branchPoints) {
        int maxBranchPoints = branchPoints.stream().collect(Collectors.groupingBy(BranchPoint::getCoverageIdentifier)).values().stream().map(x -> (int)x.stream().map(BranchPoint::getUniqueKey).distinct().count()).max(Comparator.comparingInt(x -> x)).orElse(0);
        int coveredBranchPoints = (int)branchPoints.stream().filter(x -> x.getHits() > 0).map(BranchPoint::getUniqueKey).distinct().count();
        return new BranchCoverage(lineNumber, maxBranchPoints, Math.min(coveredBranchPoints, maxBranchPoints));
    }
}

