/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.dotnet.shared.plugins;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.sonar.api.config.Configuration;
import org.sonar.api.scanner.ScannerSide;
import org.sonarsource.dotnet.shared.plugins.AbstractPropertyDefinitions;

@ScannerSide
public abstract class AbstractLanguageConfiguration {
    private final String languageKey;
    protected final Configuration configuration;

    protected AbstractLanguageConfiguration(Configuration configuration, String languageKey) {
        this.configuration = configuration;
        this.languageKey = languageKey;
    }

    public boolean ignoreThirdPartyIssues() {
        return this.configuration.getBoolean(AbstractPropertyDefinitions.getIgnoreIssuesProperty(this.languageKey)).orElse(false);
    }

    public Set<String> bugCategories() {
        return new HashSet<String>(Arrays.asList(this.configuration.getStringArray(AbstractPropertyDefinitions.getBugCategoriesProperty(this.languageKey))));
    }

    public Set<String> codeSmellCategories() {
        return new HashSet<String>(Arrays.asList(this.configuration.getStringArray(AbstractPropertyDefinitions.getCodeSmellCategoriesProperty(this.languageKey))));
    }

    public Set<String> vulnerabilityCategories() {
        return new HashSet<String>(Arrays.asList(this.configuration.getStringArray(AbstractPropertyDefinitions.getVulnerabilityCategoriesProperty(this.languageKey))));
    }

    public boolean analyzeGeneratedCode() {
        return this.configuration.getBoolean(AbstractPropertyDefinitions.getAnalyzeGeneratedCode(this.languageKey)).orElse(false);
    }
}

