/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.dotnet.shared.plugins;

import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonar.api.batch.ScannerSide;
import org.sonar.api.batch.fs.FileSystem;
import org.sonar.api.batch.fs.InputFile;
import org.sonar.api.batch.sensor.Sensor;
import org.sonar.api.batch.sensor.SensorContext;
import org.sonar.api.batch.sensor.SensorDescriptor;
import org.sonar.api.config.Configuration;
import org.sonarsource.dotnet.shared.CallableUtils;
import org.sonarsource.dotnet.shared.plugins.AbstractPropertyDefinitions;
import org.sonarsource.dotnet.shared.plugins.DotNetPluginMetadata;
import org.sonarsource.dotnet.shared.plugins.ProjectTypeCollector;
import org.sonarsource.dotnet.shared.plugins.SensorContextUtils;

@ScannerSide
public class FileTypeSensor
implements Sensor {
    private static final Logger LOG = LoggerFactory.getLogger(FileTypeSensor.class);
    private final ProjectTypeCollector projectTypeCollector;
    private final DotNetPluginMetadata pluginMetadata;

    public FileTypeSensor(ProjectTypeCollector projectTypeCollector, DotNetPluginMetadata pluginMetadata) {
        this.projectTypeCollector = projectTypeCollector;
        this.pluginMetadata = pluginMetadata;
    }

    public void describe(SensorDescriptor descriptor) {
        String name = String.format("%s Project Type Information", this.pluginMetadata.shortLanguageName());
        descriptor.name(name);
    }

    public void execute(SensorContext context) {
        FileSystem fs = context.fileSystem();
        Configuration configuration = context.config();
        boolean hasMainFiles = SensorContextUtils.hasFilesOfType(fs, InputFile.Type.MAIN, this.pluginMetadata.languageKey());
        boolean hasTestFiles = SensorContextUtils.hasFilesOfType(fs, InputFile.Type.TEST, this.pluginMetadata.languageKey());
        Optional<String> analyzerWorkDir = this.getAnalyzerWorkDir(configuration);
        if (analyzerWorkDir.isPresent()) {
            Object[] objectArray = new Object[6];
            objectArray[0] = hasMainFiles;
            objectArray[1] = hasTestFiles;
            objectArray[2] = CallableUtils.lazy(() -> FileTypeSensor.getValueOrEmpty(configuration, "sonar.projectName"));
            objectArray[3] = CallableUtils.lazy(() -> FileTypeSensor.getValueOrEmpty(configuration, "sonar.projectKey"));
            objectArray[4] = CallableUtils.lazy(() -> FileTypeSensor.getValueOrEmpty(configuration, "sonar.projectBaseDir"));
            objectArray[5] = CallableUtils.lazy(analyzerWorkDir::get);
            LOG.debug("Adding file type information (has MAIN '{}', has TEST '{}') for project '{}' (project key '{}', base dir '{}'). For debug info, see ProjectInfo.xml in '{}'.", objectArray);
            this.projectTypeCollector.addProjectInfo(hasMainFiles, hasTestFiles);
        }
    }

    private Optional<String> getAnalyzerWorkDir(Configuration configuration) {
        String property = AbstractPropertyDefinitions.getAnalyzerWorkDirProperty(this.pluginMetadata.languageKey());
        CharSequence[] values = configuration.getStringArray(property);
        if (values == null || values.length == 0) {
            return Optional.empty();
        }
        return Optional.of(String.join((CharSequence)", ", values));
    }

    private static String getValueOrEmpty(Configuration configuration, String key) {
        Optional optional = configuration.get(key);
        return optional.isPresent() ? (String)optional.get() : "";
    }
}

