/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.dotnet.shared.sarif;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.reflect.TypeToken;
import java.io.File;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.function.UnaryOperator;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonar.api.scanner.fs.InputProject;
import org.sonarsource.dotnet.shared.sarif.Location;
import org.sonarsource.dotnet.shared.sarif.SarifParser;
import org.sonarsource.dotnet.shared.sarif.SarifParserCallback;

class SarifParser10
implements SarifParser {
    private static final Logger LOG = LoggerFactory.getLogger(SarifParser10.class);
    private static final String PROPERTIES_PROP = "properties";
    private static final String LEVEL_PROP = "level";
    private final InputProject inputProject;
    private final JsonObject root;
    private final UnaryOperator<String> toRealPath;

    SarifParser10(InputProject inputProject, JsonObject root, UnaryOperator<String> toRealPath) {
        this.inputProject = inputProject;
        this.root = root;
        this.toRealPath = toRealPath;
    }

    @Override
    public void accept(SarifParserCallback callback) {
        if (!this.root.has("runs")) {
            return;
        }
        for (JsonElement runElement : this.root.get("runs").getAsJsonArray()) {
            JsonObject run = runElement.getAsJsonObject();
            if (run.has("rules")) {
                SarifParser10.handleRules(run.getAsJsonObject("rules"), callback);
            }
            if (!run.has("results")) continue;
            this.handleIssues(run.getAsJsonArray("results"), callback);
        }
    }

    private static void handleRules(JsonObject rules, SarifParserCallback callback) {
        for (Map.Entry<String, JsonElement> ruleEl : rules.entrySet()) {
            JsonObject ruleObj = ruleEl.getValue().getAsJsonObject();
            SarifParser10.handleRule(ruleObj, callback);
        }
    }

    private static void handleRule(JsonObject ruleObj, SarifParserCallback callback) {
        JsonObject props;
        String ruleId = ruleObj.get("id").getAsString();
        String shortDescription = ruleObj.has("shortDescription") ? ruleObj.get("shortDescription").getAsString() : null;
        String fullDescription = ruleObj.has("fullDescription") ? ruleObj.get("fullDescription").getAsString() : null;
        String defaultLevel = ruleObj.has("defaultLevel") ? ruleObj.get("defaultLevel").getAsString() : "warning";
        String category = null;
        if (ruleObj.has(PROPERTIES_PROP) && (props = ruleObj.getAsJsonObject(PROPERTIES_PROP)).has("category")) {
            category = props.get("category").getAsString();
        }
        callback.onRule(ruleId, shortDescription, fullDescription, defaultLevel, category);
    }

    private void handleIssues(JsonArray results, SarifParserCallback callback) {
        for (JsonElement resultEl : results) {
            JsonObject resultObj = resultEl.getAsJsonObject();
            this.handleIssue(resultObj, callback);
        }
    }

    private void handleIssue(JsonObject resultObj, SarifParserCallback callback) {
        String level;
        String message;
        if (SarifParser10.isSuppressed(resultObj)) {
            return;
        }
        String ruleId = resultObj.get("ruleId").getAsString();
        String string = message = resultObj.has("message") ? resultObj.get("message").getAsString() : null;
        if (message == null) {
            LOG.warn("Issue raised without a message for rule {}. Content: {}.", (Object)ruleId, (Object)resultObj);
            return;
        }
        String string2 = level = resultObj.has(LEVEL_PROP) ? resultObj.get(LEVEL_PROP).getAsString() : null;
        if (!this.handleLocationsElement(resultObj, ruleId, message, callback)) {
            callback.onProjectIssue(ruleId, level, this.inputProject, message);
        }
    }

    private boolean handleLocationsElement(JsonObject resultObj, String ruleId, String message, SarifParserCallback callback) {
        JsonObject properties;
        if (!resultObj.has("locations")) {
            return false;
        }
        String level = resultObj.has(LEVEL_PROP) ? resultObj.get(LEVEL_PROP).getAsString() : null;
        JsonArray locations = resultObj.getAsJsonArray("locations");
        if (locations.size() != 1) {
            return false;
        }
        JsonArray relatedLocations = new JsonArray();
        if (resultObj.has("relatedLocations")) {
            relatedLocations = resultObj.getAsJsonArray("relatedLocations");
        }
        Map<String, String> messageMap = new HashMap<String, String>();
        if (resultObj.has(PROPERTIES_PROP) && (properties = resultObj.getAsJsonObject(PROPERTIES_PROP)).has("customProperties")) {
            messageMap = (Map)new Gson().fromJson(properties.get("customProperties"), new TypeToken<Map<String, String>>(){}.getType());
        }
        JsonObject firstIssueLocation = locations.get(0).getAsJsonObject().getAsJsonObject("resultFile");
        return this.handleResultFileElement(ruleId, level, message, firstIssueLocation, relatedLocations, messageMap, callback);
    }

    private boolean handleResultFileElement(String ruleId, @Nullable String level, String message, JsonObject resultFileObj, JsonArray relatedLocations, Map<String, String> messageMap, SarifParserCallback callback) {
        if (!resultFileObj.has("uri") || !resultFileObj.has("region")) {
            return false;
        }
        ArrayList<Location> secondaryLocations = new ArrayList<Location>();
        for (JsonElement relatedLocationEl : relatedLocations) {
            JsonObject relatedLocationObj = relatedLocationEl.getAsJsonObject().getAsJsonObject("physicalLocation");
            if (!relatedLocationObj.has("uri")) {
                return false;
            }
            String secondaryMessage = messageMap.getOrDefault(String.valueOf(secondaryLocations.size()), null);
            Location secondaryLocation = this.handleLocation(relatedLocationObj, secondaryMessage);
            if (secondaryLocation == null) {
                return false;
            }
            secondaryLocations.add(secondaryLocation);
        }
        Location primaryLocation = this.handleLocation(resultFileObj, message);
        if (primaryLocation == null) {
            String uri = resultFileObj.get("uri").getAsString();
            String path = (String)this.toRealPath.apply(SarifParser10.uriToPath(uri));
            callback.onFileIssue(ruleId, level, path, secondaryLocations, message);
        } else {
            callback.onIssue(ruleId, level, primaryLocation, secondaryLocations);
        }
        return true;
    }

    @CheckForNull
    private Location handleLocation(JsonObject locationObj, String message) {
        String uri = locationObj.get("uri").getAsString();
        String path = (String)this.toRealPath.apply(SarifParser10.uriToPath(uri));
        JsonObject region = locationObj.get("region").getAsJsonObject();
        int startLine = region.get("startLine").getAsInt();
        JsonElement startColumnOrNull = region.get("startColumn");
        int startColumn = startColumnOrNull != null ? startColumnOrNull.getAsInt() : 1;
        int startLineOffset = startColumn - 1;
        JsonElement lengthOrNull = region.get("length");
        if (lengthOrNull != null) {
            return new Location(path, message, startLine, startLineOffset, startLine, startLineOffset + lengthOrNull.getAsInt());
        }
        JsonElement endLineOrNull = region.get("endLine");
        int endLine = endLineOrNull != null ? endLineOrNull.getAsInt() : startLine;
        JsonElement endColumnOrNull = region.get("endColumn");
        int endColumn = endColumnOrNull != null ? endColumnOrNull.getAsInt() : (endLineOrNull != null ? (endLine == startLine ? startColumn : 1) : startColumn);
        int endLineOffset = endColumn - 1;
        if (startColumn == endColumn && startLine == endLine) {
            return null;
        }
        return new Location(path, message, startLine, startLineOffset, endLine, endLineOffset);
    }

    private static boolean isSuppressed(JsonObject resultObj) {
        JsonArray suppressionStates = resultObj.getAsJsonArray("suppressionStates");
        if (suppressionStates != null) {
            for (JsonElement entry : suppressionStates) {
                if (!"suppressedInSource".equals(entry.getAsString())) continue;
                return true;
            }
        }
        return false;
    }

    private static String uriToPath(String uri) {
        String uriEscaped = uri.replace("[", "%5B").replace("]", "%5D");
        String uriPath = URI.create(uriEscaped).getPath();
        File file = new File(uriPath);
        return file.isAbsolute() ? file.getAbsolutePath() : file.getPath();
    }
}

