/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java;

import com.google.gson.Gson;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.lang.reflect.Modifier;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.sonar.check.Rule;

public class CheckListGenerator {
    private static final String CLASS_NAME = "GeneratedCheckList";
    public static final String RULES_PATH = "sonar-java-plugin/src/main/resources/org/sonar/l10n/java/rules/java/";
    private final Gson gson;
    final Path relativePath;
    final Path awsRelativePath;
    Path pathToWriteList;
    final String rulesPath;

    public CheckListGenerator(Gson gson, Path relativePath, Path awsRelativePath, Path pathToWriteList, String rulesPath) {
        this.gson = gson;
        this.relativePath = relativePath;
        this.awsRelativePath = awsRelativePath;
        this.pathToWriteList = pathToWriteList;
        this.rulesPath = rulesPath;
    }

    public static void main(String[] args) {
        CheckListGenerator generator = new CheckListGenerator(new Gson(), Path.of("java-checks/src/main/java", new String[0]), Path.of("java-checks-aws/src/main/java", new String[0]), Path.of("check-list/target/generated-sources/GeneratedCheckList.java", new String[0]), RULES_PATH);
        generator.generateCheckList();
    }

    public void generateCheckList() {
        List<Class<?>> checks = this.getCheckClasses();
        ArrayList mainClasses = new ArrayList();
        ArrayList testClasses = new ArrayList();
        ArrayList allClasses = new ArrayList();
        this.generateCheckListClasses(checks, mainClasses, testClasses, allClasses, this.rulesPath);
        String main = this.collectChecks(mainClasses);
        String test = this.collectChecks(testClasses);
        String all = this.collectChecks(allClasses);
        String importChecks = CheckListGenerator.generateImportStatements(checks);
        this.writeToFile(importChecks, main, test, all, this.pathToWriteList);
    }

    public List<Class<?>> getCheckClasses() {
        List<String> checkFiles = this.getCheckFiles();
        return checkFiles.stream().map(CheckListGenerator::getClassByName).filter(c -> !Modifier.isAbstract(c.getModifiers())).filter(c -> ((Rule[])c.getAnnotationsByType(Rule.class)).length != 0).toList();
    }

    private List<String> getCheckFiles() {
        List<String> list;
        block8: {
            Stream<Path> stream = Stream.concat(Files.walk(this.relativePath.resolve("org/sonar/java/checks"), new FileVisitOption[0]), Files.walk(this.awsRelativePath.resolve("org/sonar/java/checks"), new FileVisitOption[0]));
            try {
                list = stream.map(p -> p.startsWith(this.awsRelativePath) ? this.awsRelativePath.relativize((Path)p).toString() : this.relativePath.relativize((Path)p).toString()).filter(file -> file.endsWith("Check.java")).map(file -> file.replace(".java", "").replace(File.separator, ".")).sorted().toList();
                if (stream == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (stream != null) {
                        try {
                            stream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new IllegalStateException(e.getMessage());
                }
            }
            stream.close();
        }
        return list;
    }

    private static Class<?> getClassByName(String className) {
        try {
            return Class.forName(className);
        }
        catch (ClassNotFoundException e) {
            throw new IllegalStateException("Cannot find the class for name " + className, e);
        }
    }

    public String getRuleKey(Class<?> check) {
        return check.getAnnotation(Rule.class).key();
    }

    protected Metadata getMetadata(Reader reader) {
        return (Metadata)this.gson.fromJson(reader, Metadata.class);
    }

    public static String generateImportStatements(List<Class<?>> checks) {
        return checks.stream().map(c -> "import " + c.getPackageName() + "." + c.getSimpleName() + ";").collect(Collectors.joining("\n"));
    }

    public String collectChecks(List<Class<?>> classes) {
        return classes.stream().map(c -> c.getSimpleName() + ".class").collect(Collectors.joining(", \n    "));
    }

    public void generateCheckListClasses(List<Class<?>> checks, List<Class<?>> mainClasses, List<Class<?>> testClasses, List<Class<?>> allClasses, String rulesPath) {
        checks.forEach(check -> {
            String ruleKey = this.getRuleKey((Class<?>)check);
            String fileName = rulesPath + ruleKey + ".json";
            try (BufferedReader reader = Files.newBufferedReader(Path.of(fileName, new String[0]), StandardCharsets.UTF_8);){
                Metadata metadata = this.getMetadata(reader);
                switch (metadata.scope) {
                    case "All": {
                        allClasses.add((Class<?>)check);
                        return;
                    }
                    case "Main": {
                        mainClasses.add((Class<?>)check);
                        return;
                    }
                    case "Tests": {
                        testClasses.add((Class<?>)check);
                        return;
                    }
                    default: {
                        throw new IllegalStateException("Unknown scope " + metadata.scope + " for class " + check.getName());
                    }
                }
            }
            catch (IOException e) {
                throw new IllegalStateException("Could not find rule file " + fileName, e);
            }
        });
    }

    public void writeToFile(String importChecks, String mainChecks, String testChecks, String allChecks, Path path) {
        String content = "package org.sonar.java;\n\nimport java.util.Arrays;\nimport java.util.Comparator;\nimport java.util.List;\nimport java.util.Set;\nimport java.util.stream.Collectors;\nimport java.util.stream.Stream;\nimport org.sonar.plugins.java.api.JavaCheck;\n\n${importChecks}\n\npublic final class ${className} {\n\n  public static final String REPOSITORY_KEY = \"java\";\n\n  private static final List<Class<? extends JavaCheck>> JAVA_MAIN_CHECKS = Arrays.asList(\n    ${mainChecks});\n\n  private static final List<Class<? extends JavaCheck>> JAVA_TEST_CHECKS = Arrays.asList(\n    ${testChecks});\n\n  private static final List<Class<? extends JavaCheck>> JAVA_MAIN_AND_TEST_CHECKS = Arrays.asList(\n    ${allChecks});\n\n  private static final List<Class<?>> ALL_CHECKS = Stream.of(JAVA_MAIN_CHECKS, JAVA_MAIN_AND_TEST_CHECKS, JAVA_TEST_CHECKS)\n    .flatMap(List::stream)\n    .sorted(Comparator.comparing(Class::getSimpleName))\n    .collect(Collectors.toList());\n\n    private static final Set<Class<? extends JavaCheck>> JAVA_CHECKS_NOT_WORKING_FOR_AUTOSCAN = Set.of(\n      // Symbolic executions rules are not in this list because they are dynamically excluded\n      // Rules relying on correct setup of jdk.home\n      CallToDeprecatedCodeMarkedForRemovalCheck.class,\n      CallToDeprecatedMethodCheck.class,\n      // Rules relying on correct setup of java version\n      AbstractClassNoFieldShouldBeInterfaceCheck.class,\n      AnonymousClassShouldBeLambdaCheck.class,\n      CombineCatchCheck.class,\n      DateAndTimesCheck.class,\n      DateUtilsTruncateCheck.class,\n      DiamondOperatorCheck.class,\n      InsecureCreateTempFileCheck.class,\n      JdbcDriverExplicitLoadingCheck.class,\n      LambdaOptionalParenthesisCheck.class,\n      LambdaSingleExpressionCheck.class,\n      RepeatAnnotationCheck.class,\n      ReplaceGuavaWithJavaCheck.class,\n      ReplaceLambdaByMethodRefCheck.class,\n      SwitchInsteadOfIfSequenceCheck.class,\n      ThreadLocalWithInitialCheck.class,\n      TryWithResourcesCheck.class,\n      ValueBasedObjectUsedForLockCheck.class,\n      // Rules with a high deviation (>3%)\n      AccessibilityChangeCheck.class,\n      CipherBlockChainingCheck.class,\n      ClassNamedLikeExceptionCheck.class,\n      ClassWithOnlyStaticMethodsInstantiationCheck.class,\n      CollectionInappropriateCallsCheck.class,\n      DeadStoreCheck.class,\n      EqualsArgumentTypeCheck.class,\n      EqualsNotOverriddenWithCompareToCheck.class,\n      EqualsOverriddenWithHashCodeCheck.class,\n      ForLoopVariableTypeCheck.class,\n      JWTWithStrongCipherCheck.class,\n      MethodNamedEqualsCheck.class,\n      NioFileDeleteCheck.class,\n      PrivateFieldUsedLocallyCheck.class,\n      SillyEqualsCheck.class,\n      StandardCharsetsConstantsCheck.class,\n      ThreadLocalCleanupCheck.class,\n      ThreadOverridesRunCheck.class,\n      UnusedPrivateClassCheck.class,\n      UnusedPrivateFieldCheck.class,\n      VerifiedServerHostnamesCheck.class,\n      VolatileNonPrimitiveFieldCheck.class,\n      WeakSSLContextCheck.class);\n\n  private GeneratedCheckList() {\n  }\n\n  public static List<Class<?>> getChecks() {\n    return ALL_CHECKS;\n  }\n\n  public static List<Class<? extends JavaCheck>> getJavaChecks() {\n    return sortedJoin(JAVA_MAIN_CHECKS, JAVA_MAIN_AND_TEST_CHECKS);\n  }\n\n  public static List<Class<? extends JavaCheck>> getJavaTestChecks() {\n    return sortedJoin(JAVA_MAIN_AND_TEST_CHECKS, JAVA_TEST_CHECKS);\n  }\n\n  public static Set<Class<? extends JavaCheck>> getJavaChecksNotWorkingForAutoScan() {\n    return JAVA_CHECKS_NOT_WORKING_FOR_AUTOSCAN;\n  }\n\n  @SafeVarargs\n  private static List<Class<? extends JavaCheck>> sortedJoin(List<Class<? extends JavaCheck>>... lists) {\n    return Arrays.stream(lists)\n      .flatMap(List::stream)\n      .sorted(Comparator.comparing(Class::getSimpleName))\n      .toList();\n  }\n}\n".replace("${importChecks}", importChecks).replace("${className}", CLASS_NAME).replace("${mainChecks}", mainChecks).replace("${testChecks}", testChecks).replace("${allChecks}", allChecks);
        try {
            Files.writeString(path, (CharSequence)content, new OpenOption[0]);
        }
        catch (IOException e) {
            throw new IllegalStateException("Unable to write checks to the file.", e);
        }
    }

    protected static class Metadata {
        String scope;

        protected Metadata() {
        }
    }
}

