/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks.verifier.internal;

import com.google.gson.Gson;
import com.google.gson.JsonParseException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Scanner;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.function.Function;
import java.util.function.ToIntFunction;
import java.util.function.UnaryOperator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;
import org.sonar.api.utils.AnnotationUtils;
import org.sonar.check.Rule;
import org.sonar.java.RspecKey;
import org.sonar.java.annotations.VisibleForTesting;
import org.sonar.java.checks.verifier.CheckVerifier;
import org.sonar.java.reporting.AnalyzerMessage;
import org.sonar.java.reporting.JavaQuickFix;
import org.sonar.java.reporting.JavaTextEdit;
import org.sonar.plugins.java.api.IssuableSubscriptionVisitor;
import org.sonar.plugins.java.api.JavaFileScannerContext;
import org.sonar.plugins.java.api.tree.SyntaxTrivia;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonarsource.analyzer.commons.collections.MapBuilder;

class Expectations {
    private static final Map<String, IssueAttribute> ATTRIBUTE_MAP = MapBuilder.newMap().put((Object)"message", (Object)IssueAttribute.MESSAGE).put((Object)"effortToFix", (Object)IssueAttribute.EFFORT_TO_FIX).put((Object)"sc", (Object)IssueAttribute.START_COLUMN).put((Object)"startColumn", (Object)IssueAttribute.START_COLUMN).put((Object)"el", (Object)IssueAttribute.END_LINE).put((Object)"endLine", (Object)IssueAttribute.END_LINE).put((Object)"sl", (Object)IssueAttribute.START_LINE).put((Object)"ec", (Object)IssueAttribute.END_COLUMN).put((Object)"endColumn", (Object)IssueAttribute.END_COLUMN).put((Object)"secondary", (Object)IssueAttribute.SECONDARY_LOCATIONS).put((Object)"flows", (Object)IssueAttribute.FLOWS).put((Object)"order", (Object)IssueAttribute.ORDER).put((Object)"quickfixes", (Object)IssueAttribute.QUICK_FIXES).build();
    final Map<Integer, List<Issue>> issues = new HashMap<Integer, List<Issue>>();
    final Map<String, SortedSet<FlowComment>> flows = new HashMap<String, SortedSet<FlowComment>>();
    private boolean expectNoIssues = false;
    private String expectedProjectIssue = null;
    private String expectedFileIssue = null;
    private boolean collectQuickFixes = false;
    private final Map<AnalyzerMessage.TextSpan, List<JavaQuickFix>> quickFixes = new HashMap<AnalyzerMessage.TextSpan, List<JavaQuickFix>>();
    private Set<String> seenFlowIds = new HashSet<String>();

    Expectations() {
    }

    public void setCollectQuickFixes() {
        this.collectQuickFixes = true;
    }

    public Map<AnalyzerMessage.TextSpan, List<JavaQuickFix>> quickFixes() {
        return Collections.unmodifiableMap(this.quickFixes);
    }

    void setExpectNoIssues() {
        this.expectNoIssues = true;
    }

    boolean expectNoIssues() {
        return this.expectNoIssues;
    }

    boolean expectIssueAtFileLevel() {
        return StringUtils.isNotEmpty((CharSequence)this.expectedFileIssue);
    }

    void setExpectedFileIssue(String expectedMessage) {
        this.expectedFileIssue = expectedMessage;
    }

    String expectedFileIssue() {
        return this.expectedFileIssue;
    }

    boolean expectIssueAtProjectLevel() {
        return StringUtils.isNotEmpty((CharSequence)this.expectedProjectIssue);
    }

    void setExpectedProjectIssue(String expectedMessage) {
        this.expectedProjectIssue = expectedMessage;
    }

    String expectedProjectIssue() {
        return this.expectedProjectIssue;
    }

    Optional<String> containFlow(List<AnalyzerMessage> actual) {
        List<Integer> actualLines = Expectations.flowToLines(actual, AnalyzerMessage::getLine);
        Set expectedFlows = this.flows.keySet().stream().filter(flowId -> !this.seenFlowIds.contains(flowId)).filter(flowId -> Expectations.flowToLines((Collection)this.flows.get(flowId), f -> f.line).equals(actualLines)).collect(Collectors.toSet());
        if (expectedFlows.isEmpty()) {
            return Optional.empty();
        }
        if (expectedFlows.size() == 1) {
            String flowId2 = (String)expectedFlows.iterator().next();
            this.seenFlowIds.add(flowId2);
            return Optional.of(flowId2);
        }
        List actualMessages = actual.stream().map(AnalyzerMessage::getMessage).collect(Collectors.toList());
        Optional<String> foundFlow = expectedFlows.stream().filter(flowId -> this.hasSameMessages((String)flowId, actualMessages)).findFirst();
        foundFlow.ifPresent(flowId -> this.seenFlowIds.add((String)flowId));
        return foundFlow;
    }

    private boolean hasSameMessages(String flowId, List<String> actualMessages) {
        List expectedMessages = this.flows.get(flowId).stream().map(FlowComment::message).collect(Collectors.toList());
        return expectedMessages.equals(actualMessages);
    }

    Set<String> unseenFlowIds() {
        HashSet<String> result = new HashSet<String>(this.flows.keySet());
        result.removeAll(this.seenFlowIds);
        return result;
    }

    private static <T> List<Integer> flowToLines(Collection<T> flow, ToIntFunction<T> toLineFunction) {
        return flow.stream().mapToInt(toLineFunction).boxed().collect(Collectors.toList());
    }

    String flowToLines(String flowId) {
        return this.flows.get(flowId).stream().map(f -> String.valueOf(f.line)).collect(Collectors.joining(","));
    }

    Parser parser() {
        Parser parser = new Parser(this.issues, this.flows, this.quickFixes);
        if (this.collectQuickFixes) {
            parser.collectQuickFixes = true;
        }
        return parser;
    }

    Parser noEffectParser() {
        Parser parser = new Parser(this.issues, this.flows, this.quickFixes);
        parser.nonCompliantComment = Pattern.compile("NO_ISSUES_WILL_BE_COLLECTED");
        parser.shift = Pattern.compile("NO_ISSUES_WILL_BE_COLLECTED");
        parser.collectQuickFixes = false;
        return parser;
    }

    @CheckForNull
    static RemediationFunction remediationFunction(AnalyzerMessage issue) {
        String ruleKey = Expectations.ruleKey(issue);
        try {
            RuleJSON rule = Expectations.getRuleJSON(ruleKey);
            if (rule.remediation == null) {
                return null;
            }
            switch (rule.remediation.func) {
                case "Linear": {
                    return RemediationFunction.LINEAR;
                }
                case "Constant/Issue": {
                    return RemediationFunction.CONST;
                }
            }
            return null;
        }
        catch (JsonParseException | IOException e) {
            return null;
        }
    }

    private static RuleJSON getRuleJSON(String ruleKey) throws IOException {
        String ruleJson = "/org/sonar/l10n/java/rules/java/" + ruleKey + "_java.json";
        URL resource = CheckVerifier.class.getResource(ruleJson);
        if (resource == null) {
            throw new IOException(ruleJson + " not found");
        }
        Gson gson = new Gson();
        return (RuleJSON)gson.fromJson((Reader)new InputStreamReader(resource.openStream(), StandardCharsets.UTF_8), RuleJSON.class);
    }

    private static String ruleKey(AnalyzerMessage issue) {
        String ruleKey;
        RspecKey rspecKeyAnnotation = (RspecKey)AnnotationUtils.getAnnotation(issue.getCheck().getClass(), RspecKey.class);
        if (rspecKeyAnnotation != null) {
            ruleKey = rspecKeyAnnotation.value();
        } else {
            Rule ruleAnnotation = (Rule)AnnotationUtils.getAnnotation(issue.getCheck().getClass(), Rule.class);
            if (ruleAnnotation != null) {
                ruleKey = ruleAnnotation.key();
            } else {
                throw new AssertionError((Object)"Rules should be annotated with '@Rule(key = \"...\")' annotation (org.sonar.check.Rule).");
            }
        }
        return ruleKey;
    }

    @VisibleForTesting
    static class Parser
    extends IssuableSubscriptionVisitor {
        private static final String NONCOMPLIANT_FLAG = "Noncompliant";
        private final Set<SyntaxTrivia> visitedComments = new HashSet<SyntaxTrivia>();
        private Pattern nonCompliantComment = Pattern.compile("//\\s+Noncompliant");
        private Pattern shift = Pattern.compile("Noncompliant@(\\S+)");
        private static final Pattern FLOW_COMMENT = Pattern.compile("//\\s+flow");
        private static final Pattern FLOW = Pattern.compile("flow@(?<ids>\\S+).*?(?=flow@)?");
        private static final Pattern QUICK_FIX_MESSAGE = Pattern.compile("//\\s*fix@(?<id>\\S+)\\s+\\{\\{(?<message>.*)\\}\\}");
        private static final Pattern QUICK_FIX_EDIT = Pattern.compile("//\\s*edit@(?<id>\\S+).+");
        private static final String NO_QUICK_FIX_ID = "!";
        private final Map<Integer, List<Issue>> issues;
        private final Map<String, SortedSet<FlowComment>> flows;
        private final Map<AnalyzerMessage.TextSpan, List<String>> quickFixesForTextSpan = new LinkedHashMap<AnalyzerMessage.TextSpan, List<String>>();
        private final Map<AnalyzerMessage.TextSpan, List<JavaQuickFix>> quickFixes;
        private final Map<String, String> quickfixesMessages = new LinkedHashMap<String, String>();
        private final Map<String, List<QuickFixEditComment>> quickfixesEdits = new LinkedHashMap<String, List<QuickFixEditComment>>();
        private boolean collectQuickFixes = false;

        private Parser(Map<Integer, List<Issue>> issues, Map<String, SortedSet<FlowComment>> flows, Map<AnalyzerMessage.TextSpan, List<JavaQuickFix>> quickFixes) {
            this.issues = issues;
            this.flows = flows;
            this.quickFixes = quickFixes;
        }

        public List<Tree.Kind> nodesToVisit() {
            return Collections.singletonList(Tree.Kind.TRIVIA);
        }

        public void visitTrivia(SyntaxTrivia syntaxTrivia) {
            if (!this.visitedComments.add(syntaxTrivia)) {
                return;
            }
            this.collectExpectedIssues(syntaxTrivia.comment(), syntaxTrivia.range().start().line());
        }

        public void leaveFile(JavaFileScannerContext context) {
            this.consolidateQuickFixes();
            this.visitedComments.clear();
        }

        private void collectExpectedIssues(String comment, int line) {
            if (this.nonCompliantComment.matcher(comment).find()) {
                ParsedComment parsedComment = this.parseIssue(comment, line);
                if (parsedComment.issue.get((Object)IssueAttribute.QUICK_FIXES) != null && !this.collectQuickFixes) {
                    throw new AssertionError((Object)"Add \".withQuickFixes()\" to the verifier. Quick fixes are expected but the verifier is not configured to test them.");
                }
                this.issues.computeIfAbsent((Integer)IssueAttribute.LINE.get(parsedComment.issue), k -> new ArrayList()).add(parsedComment.issue);
                parsedComment.flows.forEach(f -> this.flows.computeIfAbsent(f.id, k -> Parser.newFlowSet()).add(f));
            }
            if (FLOW_COMMENT.matcher(comment).find()) {
                Parser.parseFlows(comment, line).forEach(f -> this.flows.computeIfAbsent(f.id, k -> Parser.newFlowSet()).add(f));
            }
            if (this.collectQuickFixes) {
                this.parseQuickFix(comment, line);
            }
        }

        @VisibleForTesting
        void parseQuickFix(String comment, int line) {
            Matcher messageMatcher = QUICK_FIX_MESSAGE.matcher(comment);
            if (messageMatcher.find()) {
                String quickFixId = messageMatcher.group("id");
                String quickFixMessage = messageMatcher.group("message");
                this.quickfixesMessages.put(quickFixId, quickFixMessage);
                return;
            }
            Matcher editMatcher = QUICK_FIX_EDIT.matcher(comment);
            if (editMatcher.find()) {
                String quickFixId = editMatcher.group("id");
                Map<IssueAttribute, Object> issue = Parser.parseAttributes(comment);
                String message = Parser.parseMessage(comment, comment.length());
                QuickFixEditComment quickFixEdit = new QuickFixEditComment(issue, message, line);
                this.quickfixesEdits.computeIfAbsent(quickFixId, k -> new ArrayList()).add(quickFixEdit);
            }
        }

        @VisibleForTesting
        void consolidateQuickFixes() {
            HashSet<String> allQuickFixIds = new HashSet<String>();
            for (Map.Entry<AnalyzerMessage.TextSpan, List<String>> entry : this.quickFixesForTextSpan.entrySet()) {
                AnalyzerMessage.TextSpan issueTextSpan = entry.getKey();
                ArrayList<JavaQuickFix> quickFixesForIssue = new ArrayList<JavaQuickFix>();
                for (String quickFixId : entry.getValue()) {
                    if (NO_QUICK_FIX_ID.equals(quickFixId)) continue;
                    allQuickFixIds.add(quickFixId);
                    String message = this.quickfixesMessages.get(quickFixId);
                    if (message == null) {
                        throw new AssertionError((Object)("Missing message for quick fix: " + quickFixId));
                    }
                    List<QuickFixEditComment> edits = this.quickfixesEdits.get(quickFixId);
                    if (edits == null) {
                        throw new AssertionError((Object)("Missing edits for quick fix: " + quickFixId));
                    }
                    JavaQuickFix javaQuickFix = JavaQuickFix.newQuickFix((String)message).addTextEdits(edits.stream().map(edit -> Parser.getEdit(edit, issueTextSpan, quickFixId)).collect(Collectors.toList())).build();
                    quickFixesForIssue.add(javaQuickFix);
                }
                this.quickFixes.put(issueTextSpan, quickFixesForIssue);
            }
            Stream.of(this.quickfixesMessages, this.quickfixesEdits).map(Map::keySet).flatMap(Collection::stream).filter(id -> !allQuickFixIds.contains(id)).forEach(id -> {
                throw new AssertionError((Object)("Missing issue for quick fix id: " + id));
            });
        }

        private static JavaTextEdit getEdit(QuickFixEditComment edit, AnalyzerMessage.TextSpan issueTextSpan, String quickFixId) {
            AnalyzerMessage.TextSpan textSpan = edit.getTextSpan(issueTextSpan.startLine);
            String replacement = edit.replacement();
            if (textSpan.isEmpty() && replacement.isEmpty()) {
                throw new AssertionError((Object)String.format("Unnecessary edit for quick fix id %s. TextEdits should not have empty range and text.", quickFixId));
            }
            return JavaTextEdit.replaceTextSpan((AnalyzerMessage.TextSpan)textSpan, (String)replacement);
        }

        private static TreeSet<FlowComment> newFlowSet() {
            return new TreeSet<FlowComment>(Collections.reverseOrder((rec$, x$0) -> ((FlowComment)rec$).compareTo((FlowComment)x$0)));
        }

        @VisibleForTesting
        static List<FlowComment> parseFlows(@Nullable String comment, int line) {
            if (comment == null) {
                return Collections.emptyList();
            }
            ArrayList<List<String>> flowIds = new ArrayList<List<String>>();
            ArrayList<Integer> flowStarts = new ArrayList<Integer>();
            Matcher matcher = FLOW.matcher(comment);
            while (matcher.find()) {
                List<String> ids = Arrays.asList(matcher.group("ids").split(","));
                flowIds.add(ids);
                flowStarts.add(matcher.start());
            }
            flowStarts.add(comment.length());
            return IntStream.range(0, flowIds.size()).mapToObj(i -> Parser.createFlows((List)flowIds.get(i), line, (Integer)flowStarts.get(i), comment.substring((Integer)flowStarts.get(i), (Integer)flowStarts.get(i + 1)))).flatMap(Function.identity()).collect(Collectors.toList());
        }

        private static Stream<FlowComment> createFlows(List<String> ids, int line, int startColumn, String flow) {
            EnumMap<IssueAttribute, Object> attributes = new EnumMap<IssueAttribute, Object>(IssueAttribute.class);
            attributes.putAll(Parser.parseAttributes(flow));
            String message = Parser.parseMessage(flow, flow.length());
            attributes.put(IssueAttribute.MESSAGE, message);
            return ids.stream().map(id -> new FlowComment((String)id, line, startColumn, attributes));
        }

        @VisibleForTesting
        ParsedComment parseIssue(String comment, int line) {
            Matcher shiftMatcher = this.shift.matcher(comment);
            Matcher flowMatcher = FLOW.matcher(comment);
            ParsedComment parsedComment = Parser.createIssue(line, shiftMatcher.find() ? shiftMatcher.group(1) : null, comment, Parser.parseMessage(comment, flowMatcher.find() ? flowMatcher.start() : comment.length()), comment);
            Issue attr = parsedComment.issue;
            List quickfixes = (List)IssueAttribute.QUICK_FIXES.get(attr);
            if (quickfixes != null) {
                Integer startLine = (Integer)IssueAttribute.LINE.get(attr);
                Integer endLine = (Integer)IssueAttribute.END_LINE.get(attr);
                Objects.requireNonNull(startLine);
                Integer startColumn = Parser.validateColumnPresence(IssueAttribute.START_COLUMN.get(attr), "start", startLine);
                Integer endColumn = Parser.validateColumnPresence(IssueAttribute.END_COLUMN.get(attr), "end", startLine);
                AnalyzerMessage.TextSpan textSpan = new AnalyzerMessage.TextSpan(startLine.intValue(), startColumn - 1, (endLine == null ? startLine : endLine).intValue(), endColumn - 1);
                this.quickFixesForTextSpan.put(textSpan, quickfixes);
            }
            return parsedComment;
        }

        private static Integer validateColumnPresence(@Nullable Object o, String position, Integer line) {
            if (o == null) {
                throw new AssertionError((Object)String.format("An issue with quick fixes must set the %s column ([Line %d]).", position, line));
            }
            return (Integer)o;
        }

        private static ParsedComment createIssue(int line, @Nullable String shift, @Nullable String attributes, @Nullable String message, @Nullable String flow) {
            Issue issue = new Issue();
            issue.put(IssueAttribute.LINE, Parser.parseLineShifting(shift).getLine(line));
            Map<IssueAttribute, Object> attrs = Parser.parseAttributes(attributes);
            attrs = Parser.adjustEndLine(attrs, line);
            attrs = Parser.convertSecondaryLocations(attrs, line);
            issue.putAll(attrs);
            if (message != null) {
                issue.put(IssueAttribute.MESSAGE, message);
            }
            List<FlowComment> flows = Parser.parseFlows(flow, line);
            return new ParsedComment(issue, flows);
        }

        private static LineRef parseLineShifting(@Nullable String shift) {
            if (shift == null) {
                return new LineRef.RelativeLineRef(0);
            }
            try {
                return LineRef.fromString(shift);
            }
            catch (NumberFormatException e) {
                throw new AssertionError((Object)"Use only '@+N' or '@-N' to shifts messages.");
            }
        }

        private static Map<IssueAttribute, Object> parseAttributes(@Nullable String comment) {
            if ((comment = StringUtils.substringBetween((String)comment, (String)"[[", (String)"]]")) == null) {
                return Collections.emptyMap();
            }
            return Arrays.stream(comment.split(";")).map(Parser::parseAttribute).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        }

        private static Map<IssueAttribute, Object> adjustEndLine(Map<IssueAttribute, Object> attributes, int line) {
            Object endLine = attributes.get((Object)IssueAttribute.END_LINE);
            if (endLine instanceof LineRef.RelativeLineRef) {
                LineRef.RelativeLineRef relativeLineRef = (LineRef.RelativeLineRef)endLine;
                if (relativeLineRef.offset < 0) {
                    throw new AssertionError((Object)"endLine attribute should be relative to the line and must be +N with N integer");
                }
                EnumMap<IssueAttribute, Object> copy = new EnumMap<IssueAttribute, Object>(attributes);
                copy.put(IssueAttribute.END_LINE, (Object)new LineRef.AbsoluteLineRef(relativeLineRef.getLine(line)));
                return copy;
            }
            return attributes;
        }

        private static Map<IssueAttribute, Object> convertSecondaryLocations(Map<IssueAttribute, Object> attributes, int line) {
            List secondaryLocation = (List)attributes.get((Object)IssueAttribute.SECONDARY_LOCATIONS);
            if (secondaryLocation != null) {
                EnumMap<IssueAttribute, Object> copy = new EnumMap<IssueAttribute, Object>(attributes);
                copy.put(IssueAttribute.SECONDARY_LOCATIONS, secondaryLocation.stream().map(stringValue -> Parser.relativeValueToInt(line, (String)stringValue)).collect(Collectors.toList()));
                return copy;
            }
            return attributes;
        }

        private static int relativeValueToInt(int reference, String relativeValue) {
            int value = Integer.parseInt(relativeValue);
            if (relativeValue.startsWith("+") || relativeValue.startsWith("-")) {
                return reference + value;
            }
            return value;
        }

        private static Map.Entry<IssueAttribute, Object> parseAttribute(String attribute) {
            try (Scanner scanner = new Scanner(attribute);){
                scanner.useDelimiter("[=]+");
                String name = scanner.next();
                if (!ATTRIBUTE_MAP.containsKey(name)) {
                    throw new AssertionError((Object)String.format("// Noncompliant attributes not valid: '%s'", attribute));
                }
                IssueAttribute key = (IssueAttribute)((Object)ATTRIBUTE_MAP.get(name));
                Object value = key.setter.apply(scanner.hasNext() ? scanner.next() : null);
                AbstractMap.SimpleImmutableEntry<IssueAttribute, Object> simpleImmutableEntry = new AbstractMap.SimpleImmutableEntry<IssueAttribute, Object>(key, value);
                return simpleImmutableEntry;
            }
        }

        private static String parseMessage(String cleanedComment, int horizon) {
            return StringUtils.substringBetween((String)cleanedComment.substring(0, horizon), (String)"{{", (String)"}}");
        }

        static class ParsedComment {
            final Issue issue;
            final List<FlowComment> flows;

            private ParsedComment(Issue issue, List<FlowComment> flows) {
                this.issue = issue;
                this.flows = flows;
            }
        }

        static abstract class LineRef {
            LineRef() {
            }

            abstract int getLine(int var1);

            static LineRef fromString(String input) {
                if (input.startsWith("+") || input.startsWith("-")) {
                    return new RelativeLineRef(Integer.valueOf(input));
                }
                return new AbsoluteLineRef(Integer.valueOf(input));
            }

            static int toLine(Object ref) {
                return ((LineRef)ref).getLine(0);
            }

            public int hashCode() {
                return Objects.hash(this.getLine(0));
            }

            public boolean equals(Object obj) {
                return obj != null && LineRef.class.isAssignableFrom(obj.getClass()) && Objects.equals(this.getLine(0), ((LineRef)obj).getLine(0));
            }

            static class RelativeLineRef
            extends LineRef {
                final int offset;

                RelativeLineRef(int offset) {
                    this.offset = offset;
                }

                @Override
                int getLine(int ref) {
                    return ref + this.offset;
                }
            }

            static class AbsoluteLineRef
            extends LineRef {
                final int line;

                public AbsoluteLineRef(int line) {
                    this.line = line;
                }

                @Override
                public int getLine(int ref) {
                    return this.line;
                }
            }
        }
    }

    static class RuleJSON {
        Remediation remediation;

        RuleJSON() {
        }

        static class Remediation {
            String func;

            Remediation() {
            }
        }
    }

    static enum RemediationFunction {
        LINEAR,
        CONST;

    }

    static class FlowComment {
        final String id;
        final int line;
        final Map<IssueAttribute, Object> attributes;
        final int startColumn;

        private FlowComment(String id, int line, int startColumn, Map<IssueAttribute, Object> attributes) {
            this.id = id;
            this.line = line;
            this.startColumn = startColumn;
            this.attributes = Collections.unmodifiableMap(attributes);
        }

        private int compareTo(FlowComment other) {
            if (this == other) {
                return 0;
            }
            Integer thisOrder = (Integer)IssueAttribute.ORDER.get(this.attributes);
            Integer otherOrder = (Integer)IssueAttribute.ORDER.get(other.attributes);
            if (thisOrder != null && otherOrder != null) {
                if (thisOrder.equals(otherOrder)) {
                    throw new AssertionError((Object)String.format("Same explicit ORDER=%s provided for two comments.%n%s%n%s", thisOrder, this, other));
                }
                return thisOrder.compareTo(otherOrder);
            }
            if (thisOrder == null && otherOrder == null) {
                int compareLines = Integer.compare(this.line, other.line);
                return compareLines != 0 ? compareLines : Integer.compare(this.startColumn, other.startColumn);
            }
            throw new AssertionError((Object)String.format("Mixed explicit and implicit order in same flow.%n%s%n%s", this, other));
        }

        @CheckForNull
        String message() {
            return (String)IssueAttribute.MESSAGE.get(this.attributes);
        }

        public String toString() {
            return String.format("%d: flow@%s %s", this.line, this.id, this.attributes.toString());
        }
    }

    static enum IssueAttribute {
        LINE(Function.identity()),
        ORDER(Integer::valueOf),
        MESSAGE(Function.identity()),
        START_COLUMN(Integer::valueOf),
        END_COLUMN(Integer::valueOf),
        END_LINE(Parser.LineRef::fromString, Parser.LineRef::toLine),
        START_LINE(Parser.LineRef::fromString, Parser.LineRef::toLine),
        EFFORT_TO_FIX(Double::valueOf),
        SECONDARY_LOCATIONS(IssueAttribute.multiValueAttribute(Function.identity())),
        FLOWS(IssueAttribute.multiValueAttribute(Function.identity())),
        QUICK_FIXES(IssueAttribute.multiValueAttribute(Function.identity()));

        private Function<String, ?> setter;
        private Function<Object, Object> getter = Function.identity();

        private IssueAttribute(Function<String, ?> setter) {
            this.setter = setter;
        }

        private IssueAttribute(Function<String, ?> setter, UnaryOperator<Object> getter) {
            this.setter = setter;
            this.getter = getter;
        }

        private static <T> Function<String, List<T>> multiValueAttribute(Function<String, T> convert) {
            return input -> IssueAttribute.isNullOrEmpty(input) ? Collections.emptyList() : Arrays.stream(input.split(",")).map(String::trim).map(convert).collect(Collectors.toList());
        }

        private static boolean isNullOrEmpty(@Nullable String input) {
            return input == null || input.trim().isEmpty();
        }

        <T> T get(Map<IssueAttribute, Object> values) {
            Object rawValue = values.get((Object)this);
            return (T)(rawValue == null ? null : this.getter.apply(rawValue));
        }
    }

    private static class QuickFixEditComment {
        final Map<IssueAttribute, Object> attributes;
        @Nullable
        final String replacement;
        final int commentLine;

        public QuickFixEditComment(Map<IssueAttribute, Object> attributes, @Nullable String replacement, int commentLine) {
            this.attributes = attributes;
            this.replacement = replacement;
            this.commentLine = commentLine;
        }

        String replacement() {
            if (this.replacement == null) {
                throw new AssertionError((Object)"Quickfix edit should contain a replacement.");
            }
            return this.replacement;
        }

        AnalyzerMessage.TextSpan getTextSpan(int issueLine) {
            int startLine = QuickFixEditComment.getAbsoluteLine(this.attributes.get((Object)IssueAttribute.START_LINE), issueLine);
            int startColumn = QuickFixEditComment.getColumnOffset(IssueAttribute.START_COLUMN.get(this.attributes), "start", this.commentLine);
            int endColumn = QuickFixEditComment.getColumnOffset(IssueAttribute.END_COLUMN.get(this.attributes), "end", this.commentLine);
            Object endLineAttribute = this.attributes.get((Object)IssueAttribute.END_LINE);
            int endLine = endLineAttribute == null ? issueLine : QuickFixEditComment.getAbsoluteLine(endLineAttribute, issueLine);
            return new AnalyzerMessage.TextSpan(startLine, startColumn, endLine, endColumn);
        }

        private static int getAbsoluteLine(@Nullable Object o, int issueLine) {
            if (o == null) {
                return issueLine;
            }
            return ((Parser.LineRef)o).getLine(issueLine);
        }

        private static int getColumnOffset(@Nullable Object o, String position, int line) {
            if (o instanceof Integer) {
                return (Integer)o - 1;
            }
            throw new AssertionError((Object)String.format("%s column not specified for quick fix edit at line %d.", position, line));
        }
    }

    static class Issue
    extends EnumMap<IssueAttribute, Object> {
        private Issue() {
            super(IssueAttribute.class);
        }
    }
}

