/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.sonar.check.Rule;
import org.sonar.plugins.java.api.IssuableSubscriptionVisitor;
import org.sonar.plugins.java.api.JavaCheck;
import org.sonar.plugins.java.api.semantic.Symbol;
import org.sonar.plugins.java.api.tree.ClassTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.TypeTree;

@Rule(key="S1694")
public class AbstractClassWithoutAbstractMethodCheck
extends IssuableSubscriptionVisitor {
    public List<Tree.Kind> nodesToVisit() {
        return Collections.singletonList(Tree.Kind.CLASS);
    }

    public void visitNode(Tree tree) {
        ClassTree classTree = (ClassTree)tree;
        Symbol.TypeSymbol typeSymbol = classTree.symbol();
        if (typeSymbol.isAbstract()) {
            Collection members = typeSymbol.memberSymbols();
            int nbAbstractMethod = AbstractClassWithoutAbstractMethodCheck.countAbstractMethods(members);
            int nbOfMembers = members.size() - 2;
            if (AbstractClassWithoutAbstractMethodCheck.hasDefaultConstructor(members)) {
                --nbOfMembers;
            }
            if (AbstractClassWithoutAbstractMethodCheck.isExtendingObject(classTree) && nbAbstractMethod == nbOfMembers) {
                this.context.reportIssue((JavaCheck)this, (Tree)classTree.simpleName(), "Convert this \"" + typeSymbol + "\" class to an interface");
            }
            if (nbOfMembers > 0 && nbAbstractMethod == 0 && !AbstractClassWithoutAbstractMethodCheck.isPartialImplementation(classTree)) {
                this.context.reportIssue((JavaCheck)this, (Tree)classTree.simpleName(), "Convert this \"" + typeSymbol + "\" class to a concrete class with a private constructor");
            }
        }
    }

    private static boolean hasDefaultConstructor(Collection<Symbol> members) {
        for (Symbol member : members) {
            if (!"<init>".equals(member.name()) || member.declaration() != null) continue;
            return true;
        }
        return false;
    }

    private static boolean isExtendingObject(ClassTree tree) {
        TypeTree superClass = tree.superClass();
        return superClass == null || superClass.symbolType().is("java.lang.Object");
    }

    private static boolean isPartialImplementation(ClassTree tree) {
        return tree.superClass() != null || !tree.superInterfaces().isEmpty();
    }

    private static int countAbstractMethods(Collection<? extends Symbol> symbols) {
        int abstractMethod = 0;
        for (Symbol symbol : symbols) {
            if (!AbstractClassWithoutAbstractMethodCheck.isAbstractMethod(symbol)) continue;
            ++abstractMethod;
        }
        return abstractMethod;
    }

    private static boolean isAbstractMethod(Symbol sym) {
        return sym.isMethodSymbol() && sym.isAbstract();
    }
}

