/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import java.util.Collections;
import java.util.List;
import org.sonar.check.Rule;
import org.sonar.java.resolve.ClassJavaType;
import org.sonar.java.resolve.ParametrizedTypeJavaType;
import org.sonar.java.resolve.TypeVariableJavaType;
import org.sonar.plugins.java.api.IssuableSubscriptionVisitor;
import org.sonar.plugins.java.api.tree.MethodTree;
import org.sonar.plugins.java.api.tree.Tree;

@Rule(key="S4351")
public class CompareToNotOverloadedCheck
extends IssuableSubscriptionVisitor {
    public List<Tree.Kind> nodesToVisit() {
        return Collections.singletonList(Tree.Kind.METHOD);
    }

    public void visitNode(Tree tree) {
        MethodTree methodTree = (MethodTree)tree;
        if (this.hasSemantic() && CompareToNotOverloadedCheck.isCompareToMethod(methodTree) && Boolean.FALSE.equals(methodTree.isOverriding())) {
            ClassJavaType ownerType = (ClassJavaType)methodTree.symbol().owner().type();
            ownerType.superTypes().stream().filter(supertype -> supertype.is("java.lang.Comparable")).findFirst().ifPresent(comparableType -> {
                String name = "Object";
                if (comparableType.isParameterized()) {
                    ParametrizedTypeJavaType ptjt = (ParametrizedTypeJavaType)comparableType;
                    name = ptjt.substitution((TypeVariableJavaType)ptjt.typeParameters().get(0)).symbol().name();
                }
                this.reportIssue((Tree)methodTree.parameters().get(0), "Refactor this method so that its argument is of type '" + name + "'.");
            });
        }
    }

    private static boolean isCompareToMethod(MethodTree tree) {
        return "compareTo".equals(tree.simpleName().name()) && tree.parameters().size() == 1;
    }
}

