/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import java.util.Arrays;
import java.util.List;
import org.sonar.check.Rule;
import org.sonar.java.checks.helpers.ExpressionsHelper;
import org.sonar.java.checks.methods.AbstractMethodDetection;
import org.sonar.java.matcher.MethodMatcher;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.MethodInvocationTree;
import org.sonar.plugins.java.api.tree.Tree;

@Rule(key="S3331")
public class CookieDomainCheck
extends AbstractMethodDetection {
    @Override
    protected List<MethodMatcher> getMethodInvocationMatchers() {
        return Arrays.asList(MethodMatcher.create().typeDefinition("javax.servlet.http.Cookie").name("setDomain").addParameter("java.lang.String"), MethodMatcher.create().typeDefinition("java.net.HttpCookie").name("setDomain").addParameter("java.lang.String"));
    }

    @Override
    protected void onMethodInvocationFound(MethodInvocationTree mit) {
        ExpressionTree arg = (ExpressionTree)mit.arguments().get(0);
        String domain = ExpressionsHelper.getConstantValueAsString(arg).value();
        if (domain != null && !domain.isEmpty() && !domain.substring(1).contains(".")) {
            this.reportIssue((Tree)arg, "Specify at least a second-level cookie domain.");
        }
    }
}

