/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.sonar.check.Rule;
import org.sonar.java.model.ExpressionUtils;
import org.sonar.java.model.SyntacticEquivalence;
import org.sonar.plugins.java.api.IssuableSubscriptionVisitor;
import org.sonar.plugins.java.api.JavaFileScannerContext;
import org.sonar.plugins.java.api.tree.Arguments;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.MethodInvocationTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.TypeCastTree;
import org.sonar.plugins.java.api.tree.UnaryExpressionTree;

@Rule(key="S4142")
public class DuplicateArgumentCheck
extends IssuableSubscriptionVisitor {
    public List<Tree.Kind> nodesToVisit() {
        return Collections.singletonList(Tree.Kind.METHOD_INVOCATION);
    }

    public void visitNode(Tree tree) {
        MethodInvocationTree mit = (MethodInvocationTree)tree;
        Arguments arguments = mit.arguments();
        int arity = arguments.size();
        if (arity <= 1) {
            return;
        }
        HashSet<ExpressionTree> reported = new HashSet<ExpressionTree>();
        for (int i = 0; i < arity; ++i) {
            ExpressionTree arg = ExpressionUtils.skipParentheses((ExpressionTree)((ExpressionTree)arguments.get(i)));
            if (DuplicateArgumentCheck.isLiteral(arg) || arg.is(new Tree.Kind[]{Tree.Kind.IDENTIFIER}) || arg.is(new Tree.Kind[]{Tree.Kind.NEW_CLASS})) continue;
            for (int j = i + 1; j < arity; ++j) {
                ExpressionTree otherArg = ExpressionUtils.skipParentheses((ExpressionTree)((ExpressionTree)arguments.get(j)));
                if (reported.contains(otherArg) || !SyntacticEquivalence.areEquivalent((Tree)arg, (Tree)otherArg)) continue;
                this.reportIssue((Tree)otherArg, String.format("Verify that this is the intended value; it is the same as the %s argument.", DuplicateArgumentCheck.argumentNumber(i + 1)), Collections.singletonList(new JavaFileScannerContext.Location("", (Tree)arg)), null);
                reported.add(otherArg);
            }
        }
    }

    private static boolean isLiteral(ExpressionTree arg) {
        if (arg.is(new Tree.Kind[]{Tree.Kind.TYPE_CAST})) {
            return DuplicateArgumentCheck.isLiteral(((TypeCastTree)arg).expression());
        }
        if (arg instanceof UnaryExpressionTree) {
            return DuplicateArgumentCheck.isLiteral(((UnaryExpressionTree)arg).expression());
        }
        return arg.is(new Tree.Kind[]{Tree.Kind.BOOLEAN_LITERAL, Tree.Kind.CHAR_LITERAL, Tree.Kind.DOUBLE_LITERAL, Tree.Kind.FLOAT_LITERAL, Tree.Kind.INT_LITERAL, Tree.Kind.LONG_LITERAL, Tree.Kind.NULL_LITERAL, Tree.Kind.STRING_LITERAL});
    }

    private static String argumentNumber(int index) {
        switch (index) {
            case 1: {
                return "1st";
            }
            case 2: {
                return "2nd";
            }
            case 3: {
                return "3rd";
            }
        }
        return index + "th";
    }
}

